/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.archivable.impl;

import com.salesforce.cantor.Namespaceable;
import java.io.IOException;
import java.util.Collection;

abstract class AbstractBaseArchivableNamespaceable<T extends Namespaceable, A extends Namespaceable>
implements Namespaceable {
    private final T delegate;
    private final A archiveDelegate;

    public AbstractBaseArchivableNamespaceable(T delegate, A archiveDelegate) {
        this.delegate = delegate;
        this.archiveDelegate = archiveDelegate;
    }

    @Override
    public Collection<String> namespaces() throws IOException {
        Collection<String> namespaces = this.getDelegate().namespaces();
        Collection<String> archivedNamespaces = this.getArchiver().namespaces();
        if (namespaces != null && archivedNamespaces != null) {
            namespaces.addAll(archivedNamespaces);
        }
        return namespaces != null ? namespaces : archivedNamespaces;
    }

    @Override
    public void create(String namespace) throws IOException {
        this.getArchiver().create(namespace);
        this.getDelegate().create(namespace);
    }

    @Override
    public void drop(String namespace) throws IOException {
        this.getArchiver().drop(namespace);
        this.getDelegate().drop(namespace);
    }

    protected T getDelegate() {
        return this.delegate;
    }

    protected A getArchiver() {
        return this.archiveDelegate;
    }
}

