/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.async;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

abstract class AbstractBaseAsyncNamespaceable<T extends Namespaceable>
implements Namespaceable {
    private final T delegate;
    private final ExecutorService executorService;

    AbstractBaseAsyncNamespaceable(T delegate, ExecutorService executorService) {
        CommonPreconditions.checkArgument(delegate != null, "null delegate");
        CommonPreconditions.checkArgument(executorService != null, "null executor service");
        this.executorService = executorService;
        this.delegate = delegate;
    }

    <R> R submitCall(Callable<R> callable) throws IOException {
        Future<R> future = this.executorService.submit(callable);
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    protected T getDelegate() {
        return this.delegate;
    }
}

