/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.sharded;

import com.salesforce.cantor.Events;
import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.EventsPreconditions;
import com.salesforce.cantor.misc.sharded.AbstractBaseShardedNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShardedEvents
extends AbstractBaseShardedNamespaceable<Events>
implements Events {
    public ShardedEvents(Events ... delegates) {
        super((Namespaceable[])delegates);
    }

    @Override
    public void create(String namespace) throws IOException {
        EventsPreconditions.checkCreate(namespace);
        ((Events)this.getShardForCreate(namespace)).create(namespace);
        this.loadNamespaceLookupTable();
    }

    @Override
    public void drop(String namespace) throws IOException {
        EventsPreconditions.checkDrop(namespace);
        ((Events)this.getShard(namespace)).drop(namespace);
        this.loadNamespaceLookupTable();
    }

    @Override
    public void store(String namespace, Collection<Events.Event> batch) throws IOException {
        EventsPreconditions.checkStore(namespace, batch);
        ((Events)this.getShard(namespace)).store(namespace, batch);
    }

    @Override
    public List<Events.Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        EventsPreconditions.checkGet(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return ((Events)this.getShard(namespace)).get(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery, includePayloads, ascending, limit);
    }

    @Override
    public Set<String> metadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkMetadata(namespace, metadataKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return ((Events)this.getShard(namespace)).metadata(namespace, metadataKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
    }

    @Override
    public void expire(String namespace, long endTimestampMillis) throws IOException {
        EventsPreconditions.checkExpire(namespace, endTimestampMillis);
        ((Events)this.getShard(namespace)).expire(namespace, endTimestampMillis);
    }
}

