/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.mysql;

import com.salesforce.cantor.Events;
import com.salesforce.cantor.jdbc.AbstractBaseEventsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.salesforce.cantor.mysql.MysqlDataSourceProvider;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsOnMysql
extends AbstractBaseEventsOnJdbc
implements Events {
    private static final Logger logger = LoggerFactory.getLogger(EventsOnMysql.class);

    public EventsOnMysql(String hostname, int port, String username, String password) throws IOException {
        this(MysqlDataSourceProvider.getDatasource(new MysqlDataSourceProperties().setHostname(hostname).setPort(port).setUsername(username).setPassword(password)));
    }

    public EventsOnMysql(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    @Override
    protected String getCreateChunkLookupTableSql(String namespace) {
        return String.format("CREATE TABLE IF NOT EXISTS %s ( %s VARCHAR(256) NOT NULL, %s VARCHAR(256) NOT NULL, %s VARCHAR(256), %s BIGINT, PRIMARY KEY (%s, %s),  INDEX %s (%s), INDEX %s (%s), INDEX %s (%s) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ", this.getTableFullName(namespace, this.getChunksLookupTableName()), JdbcUtils.quote(this.getTableNameColumnName()), JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getStartTimestampMillisColumnName()), JdbcUtils.quote(this.getTableNameColumnName()), JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getStartTimestampMillisColumnName()), JdbcUtils.quote(this.getStartTimestampMillisColumnName()));
    }

    @Override
    protected String getCreateChunkTableSql(String chunkTableName, String namespace, Map<String, String> metadata, Map<String, Double> dimensions) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE TABLE IF NOT EXISTS ").append(this.getTableFullName(namespace, chunkTableName)).append(" (").append(JdbcUtils.quote(this.getEventTimestampColumnName())).append(" BIGINT, ");
        for (String metadataKey : this.getOrderedKeys(metadata)) {
            sqlBuilder.append(JdbcUtils.quote(this.getMetadataKeyColumnName(metadataKey))).append(" TEXT, ");
        }
        for (String dimensionKey : this.getOrderedKeys(dimensions)) {
            sqlBuilder.append(JdbcUtils.quote(this.getDimensionKeyColumnName(dimensionKey))).append(" DOUBLE, ");
        }
        sqlBuilder.append(JdbcUtils.quote(this.getPayloadColumnName())).append(" LONGBLOB, ").append("INDEX ").append(this.getEventTimestampColumnName()).append(" (").append(JdbcUtils.quote(this.getEventTimestampColumnName())).append(") ");
        int maxIndexedColumns = 63;
        int indexedColumnsCount = 0;
        for (String metadataKey : this.getOrderedKeys(metadata)) {
            if (++indexedColumnsCount > 63) break;
            sqlBuilder.append(", INDEX ").append(JdbcUtils.quote(this.getMetadataKeyColumnName(metadataKey))).append(" (").append(JdbcUtils.quote(this.getMetadataKeyColumnName(metadataKey))).append("(256)) ");
        }
        for (String dimensionKey : this.getOrderedKeys(dimensions)) {
            if (++indexedColumnsCount > 63) break;
            sqlBuilder.append(", INDEX ").append(JdbcUtils.quote(this.getDimensionKeyColumnName(dimensionKey))).append(" (").append(JdbcUtils.quote(this.getDimensionKeyColumnName(dimensionKey))).append(") ");
        }
        sqlBuilder.append(")");
        sqlBuilder.append(" ENGINE=InnoDB DEFAULT CHARSET=binary ");
        return sqlBuilder.toString();
    }

    @Override
    protected String getRegexQuery(String column) {
        return String.format(" %s REGEXP ? ", column);
    }

    @Override
    protected String getNotRegexQuery(String column) {
        return String.format(" %s NOT REGEXP ? ", column);
    }
}

