/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.mysql;

import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDataSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDataSourceProvider.class);

    public static synchronized DataSource getDatasource(MysqlDataSourceProperties builder) {
        return MysqlDataSourceProvider.doGetDataSource(builder.getHostname(), builder.getPort(), builder.getUsername(), builder.getPassword());
    }

    private static DataSource doGetDataSource(String hostname, int port, String username, String password) {
        String jdbcUrl = "jdbc:mysql://" + hostname + ":" + port + "/";
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        HikariDataSource connectoinPoolDataSource = new HikariDataSource();
        connectoinPoolDataSource.setJdbcUrl(jdbcUrl);
        connectoinPoolDataSource.setUsername(username);
        if (password != null) {
            connectoinPoolDataSource.setPassword(password);
        }
        connectoinPoolDataSource.setConnectionTimeout(30000L);
        connectoinPoolDataSource.addDataSourceProperty("useUnicode", true);
        connectoinPoolDataSource.addDataSourceProperty("useSSL", false);
        connectoinPoolDataSource.addDataSourceProperty("allowPublicKeyRetrieval", true);
        connectoinPoolDataSource.addDataSourceProperty("serverTimezone", "UTC");
        connectoinPoolDataSource.addDataSourceProperty("useJDBCCompliantTimezoneShift", true);
        connectoinPoolDataSource.addDataSourceProperty("useLegacyDatetimeCode", false);
        connectoinPoolDataSource.addDataSourceProperty("cachePrepStmts", true);
        connectoinPoolDataSource.addDataSourceProperty("prepStmtCacheSize", 512);
        connectoinPoolDataSource.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
        connectoinPoolDataSource.addDataSourceProperty("useServerPrepStmts", true);
        connectoinPoolDataSource.addDataSourceProperty("useLocalSessionState", true);
        connectoinPoolDataSource.addDataSourceProperty("rewriteBatchedStatements", true);
        connectoinPoolDataSource.addDataSourceProperty("cacheResultSetMetadata", true);
        connectoinPoolDataSource.addDataSourceProperty("metadataCacheSize", 512);
        connectoinPoolDataSource.addDataSourceProperty("cacheServerConfiguration", true);
        connectoinPoolDataSource.addDataSourceProperty("elideSetAutoCommits", true);
        connectoinPoolDataSource.addDataSourceProperty("continueBatchOnError", false);
        connectoinPoolDataSource.addDataSourceProperty("maintainTimeStats", false);
        connectoinPoolDataSource.addDataSourceProperty("maxRows", 100000);
        connectoinPoolDataSource.setMaximumPoolSize(64);
        logger.info("jdbc url for datasource is: {} data source properties are: {}", (Object)jdbcUrl, (Object)connectoinPoolDataSource.getDataSourceProperties());
        return connectoinPoolDataSource;
    }
}

