/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.server;

import com.google.common.base.Strings;
import com.salesforce.cantor.common.CommonPreconditions;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CantorEnvironment {
    private final Map<String, String> environmentVariables = System.getenv();
    private final Config config;

    public CantorEnvironment(Config config) {
        this.config = config;
    }

    public String getEnvironmentVariable(String key) {
        return this.environmentVariables.get(key);
    }

    public String getStorageType() {
        return this.config.getString("cantor.storage.type");
    }

    public List<? extends Config> getConfigAsList(String config) {
        CommonPreconditions.checkArgument(!Strings.isNullOrEmpty(config), "null/empty config path");
        return this.getIfHasPath(this.config::getConfigList, this.getConfigPath(config), Collections.emptyList());
    }

    public int getConfigAsInteger(String config, int defaultValue) {
        CommonPreconditions.checkArgument(!Strings.isNullOrEmpty(config), "null/empty config path");
        return this.getIfHasPath(this.config::getInt, this.getConfigPath(config), defaultValue);
    }

    private <T> T getIfHasPath(Function<String, T> getter, String path, T ifNoPath) {
        if (this.config.hasPath(path)) {
            return getter.apply(path);
        }
        return ifNoPath;
    }

    private String getConfigPath(String config) {
        return "cantor." + config;
    }
}

