/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.server.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.h2.CantorOnH2;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.misc.async.AsyncCantor;
import com.salesforce.cantor.misc.loggable.LoggableCantor;
import com.salesforce.cantor.misc.rw.ReadWriteCantor;
import com.salesforce.cantor.misc.sharded.ShardedCantor;
import com.salesforce.cantor.mysql.CantorOnMysql;
import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.salesforce.cantor.mysql.MysqlDataSourceProvider;
import com.salesforce.cantor.server.CantorEnvironment;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CantorFactory {
    private static final Logger logger = LoggerFactory.getLogger(CantorFactory.class);
    private static final String ENV_MYSQL_SHARDS = "MYSQL_SHARDS";
    private final CantorEnvironment cantorEnvironment;

    public CantorFactory(CantorEnvironment cantorEnvironment) {
        this.cantorEnvironment = cantorEnvironment;
    }

    public Cantor getCantor() throws IOException {
        String storageType = this.cantorEnvironment.getStorageType();
        if (storageType.equalsIgnoreCase("mysql")) {
            String mysqlShards = this.cantorEnvironment.getEnvironmentVariable(ENV_MYSQL_SHARDS);
            List<MysqlDataSourceProperties> dataSources = mysqlShards != null ? this.getMysqlFromEnv(mysqlShards) : this.getMysqlDataSourceProperties(this.cantorEnvironment.getConfigAsList(storageType));
            if (dataSources.size() == 1) {
                logger.info("creating single instance mysql cantor...");
                CantorOnMysql readCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(0)));
                CantorOnMysql writeCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(0)));
                return new LoggableCantor(new AsyncCantor(new ReadWriteCantor(writeCantor, readCantor), this.newExecutorService(32)));
            }
            Cantor[] cantors = new Cantor[dataSources.size()];
            for (int index = 0; index < cantors.length; ++index) {
                CantorOnMysql readCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(index)));
                CantorOnMysql writeCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(index)));
                cantors[index] = new AsyncCantor(new ReadWriteCantor(writeCantor, readCantor), this.newExecutorService(32));
            }
            logger.info("creating shared mysql cantor with {} instances: {}", (Object)cantors.length, (Object)dataSources);
            return new LoggableCantor(new ShardedCantor(cantors));
        }
        if (storageType.equalsIgnoreCase("h2")) {
            List<H2DataSourceProperties> dataSources = this.getH2DataSourceProperties(this.cantorEnvironment.getConfigAsList(storageType));
            if (dataSources.size() == 1) {
                logger.info("creating single instance h2 cantor...");
                return new LoggableCantor(new CantorOnH2(H2DataSourceProvider.getDatasource(dataSources.get(0))));
            }
            Cantor[] cantors = new Cantor[dataSources.size()];
            for (int index = 0; index < cantors.length; ++index) {
                cantors[index] = new CantorOnH2(H2DataSourceProvider.getDatasource(dataSources.get(index)));
            }
            logger.info("creating shared h2 cantor with {} instances: {}", (Object)cantors.length, (Object)dataSources);
            return new LoggableCantor(new ShardedCantor(cantors));
        }
        throw new IllegalArgumentException("invalid storage type");
    }

    private List<MysqlDataSourceProperties> getMysqlFromEnv(String mysqlShardsString) {
        String[] mysqlShards;
        ArrayList<MysqlDataSourceProperties> propertiesList = new ArrayList<MysqlDataSourceProperties>();
        for (String mysqlShard : mysqlShards = mysqlShardsString.split(",")) {
            String[] hostPort = mysqlShard.split(":");
            if (hostPort.length != 2) {
                throw new IllegalArgumentException("MYSQL_SHARDS is in an invalid format. Expected: <hostname1>:<port1>,<hostname2>:<port2>,... Found: " + mysqlShardsString);
            }
            MysqlDataSourceProperties properties = new MysqlDataSourceProperties();
            properties.setHostname(hostPort[0]);
            properties.setPort(Integer.parseInt(hostPort[1]));
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    private List<MysqlDataSourceProperties> getMysqlDataSourceProperties(List<? extends Config> configObjects) {
        ArrayList<MysqlDataSourceProperties> propertiesList = new ArrayList<MysqlDataSourceProperties>();
        for (Config config : configObjects) {
            MysqlDataSourceProperties properties = new MysqlDataSourceProperties();
            properties.setHostname(config.getString("hostname"));
            properties.setPort(config.getInt("port"));
            properties.setUsername(config.getString("username"));
            properties.setPassword(config.getString("password"));
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    private List<H2DataSourceProperties> getH2DataSourceProperties(List<? extends Config> configObjects) {
        ArrayList<H2DataSourceProperties> propertiesList = new ArrayList<H2DataSourceProperties>();
        for (Config config : configObjects) {
            H2DataSourceProperties properties = new H2DataSourceProperties();
            properties.setPath(config.getString("path"));
            properties.setInMemory(config.getBoolean("in-memory"));
            properties.setCompressed(config.getBoolean("compressed"));
            properties.setUsername(config.getString("username"));
            properties.setPassword(config.getString("password"));
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    private ExecutorService newExecutorService(int concurrency) {
        return Executors.newFixedThreadPool(concurrency, new ThreadFactoryBuilder().setNameFormat("cantor-worker-%d").build());
    }
}

