/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import javax.annotation.Nullable;

@Internal
public abstract class InternalConfigSelector {
    public static final Attributes.Key<InternalConfigSelector> KEY = Attributes.Key.create("io.grpc.config-selector");

    public abstract Result selectConfig(LoadBalancer.PickSubchannelArgs var1);

    public static final class Result {
        private final Status status;
        private final Object config;
        private final CallOptions callOptions;
        @Nullable
        private final Runnable committedCallback;

        private Result(Status status, Object config, CallOptions callOptions, Runnable committedCallback) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.config = config;
            this.callOptions = callOptions;
            this.committedCallback = committedCallback;
        }

        public static Result forError(Status status) {
            Preconditions.checkArgument(!status.isOk(), "status is OK");
            return new Result(status, null, null, null);
        }

        public Status getStatus() {
            return this.status;
        }

        public Object getConfig() {
            return this.config;
        }

        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        @Nullable
        public Runnable getCommittedCallback() {
            return this.committedCallback;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Object config;
            private CallOptions callOptions;
            private Runnable committedCallback;

            private Builder() {
            }

            public Builder setConfig(Object config) {
                this.config = Preconditions.checkNotNull(config, "config");
                return this;
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
                return this;
            }

            public Builder setCommittedCallback(Runnable committedCallback) {
                this.committedCallback = Preconditions.checkNotNull(committedCallback, "committedCallback");
                return this;
            }

            public Result build() {
                Preconditions.checkState(this.config != null, "config is not set");
                Preconditions.checkState(this.callOptions != null, "callOptions is not set");
                return new Result(Status.OK, this.config, this.callOptions, this.committedCallback);
            }
        }
    }
}

