/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.common;

public class CommonPreconditions {
    public static final int MAX_NAMESPACE_LENGHT = 512;

    public static void checkString(String string) {
        CommonPreconditions.checkString(string, "null/empty string");
    }

    public static void checkString(String string, int maxLength) {
        CommonPreconditions.checkString(string, "null/empty string");
        CommonPreconditions.checkArgument(string.length() <= maxLength, "string cannot be longer than " + maxLength + " characters");
    }

    public static void checkString(String string, String message) {
        CommonPreconditions.checkArgument(string != null && string.length() > 0, message);
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkNamespace(String namespace) {
        CommonPreconditions.checkString(namespace, "null/empty namespace");
        CommonPreconditions.checkArgument(namespace.length() < 512, "namespace longer than 512 chars");
    }

    public static void checkCreate(String namespace) {
        CommonPreconditions.checkNamespace(namespace);
    }

    public static void checkDrop(String namespace) {
        CommonPreconditions.checkNamespace(namespace);
    }
}

