/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.salesforce.cantor.common.CommonPreconditions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

abstract class AbstractBaseGrpcClient<StubType extends AbstractStub<StubType>> {
    private static final long defaultChannelRefreshTimeMillis = 600000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<ManagedChannel> channel = new AtomicReference();
    private final AtomicReference<ManagedChannel> oldChannel = new AtomicReference();
    private final String target;
    private final Function<Channel, StubType> stubConstructor;

    AbstractBaseGrpcClient(Function<Channel, StubType> stubConstructor, String target) {
        CommonPreconditions.checkString(target, "null/empty target");
        this.target = target;
        this.stubConstructor = stubConstructor;
        SLF4JBridgeHandler.install();
        this.refreshGrpcChannel();
        ScheduledExecutorService refreshChannelExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("cantor-grpc-refresh-channel-%d").build());
        refreshChannelExecutorService.scheduleWithFixedDelay(this::refreshGrpcChannel, 600000L, 600000L, TimeUnit.MILLISECONDS);
    }

    StubType getStub() {
        return (StubType)((AbstractStub)this.makeStubs()).withDeadlineAfter(60L, TimeUnit.SECONDS);
    }

    <R> R call(Callable<R> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus() != null && e.getStatus().getCause() != null) {
                throw new IOException(e.getStatus().getCause());
            }
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private ManagedChannel makeChannel() {
        this.logger.info("creating channel for target '{}'", (Object)this.target);
        return ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(this.target).usePlaintext()).maxInboundMessageSize(0x4000000)).executor(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("cantor-grpc-client-%d").build()))).build();
    }

    private StubType makeStubs() {
        return (StubType)((AbstractStub)this.stubConstructor.apply(this.channel.get()));
    }

    private void refreshGrpcChannel() {
        this.logger.info("refreshing grpc channel at timeInMillis={} on refreshInterval={}", (Object)System.currentTimeMillis(), (Object)600000L);
        ManagedChannel channelToClose = this.oldChannel.getAndSet(this.channel.getAndSet(this.makeChannel()));
        if (channelToClose != null) {
            channelToClose.shutdown();
        }
    }
}

