/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.grpc.GrpcUtils;
import com.salesforce.cantor.grpc.events.CreateRequest;
import com.salesforce.cantor.grpc.events.DimensionRequest;
import com.salesforce.cantor.grpc.events.DimensionResponse;
import com.salesforce.cantor.grpc.events.DropRequest;
import com.salesforce.cantor.grpc.events.EventProto;
import com.salesforce.cantor.grpc.events.EventsServiceGrpc;
import com.salesforce.cantor.grpc.events.ExpireRequest;
import com.salesforce.cantor.grpc.events.GetRequest;
import com.salesforce.cantor.grpc.events.GetResponse;
import com.salesforce.cantor.grpc.events.MetadataRequest;
import com.salesforce.cantor.grpc.events.MetadataResponse;
import com.salesforce.cantor.grpc.events.StoreRequest;
import com.salesforce.cantor.grpc.events.StoreRequests;
import com.salesforce.cantor.grpc.events.VoidResponse;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class EventsGrpcService
extends EventsServiceGrpc.EventsServiceImplBase {
    private final Cantor cantor;

    public EventsGrpcService(Cantor cantor) {
        CommonPreconditions.checkArgument(cantor != null, "null cantor");
        this.cantor = cantor;
    }

    @Override
    public void create(CreateRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getEvents().create(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void drop(DropRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getEvents().drop(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void get(GetRequest request, StreamObserver<GetResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            GetResponse.Builder responseBuilder = GetResponse.newBuilder();
            List<Events.Event> results = this.getEvents().get(request.getNamespace(), request.getStartTimestampMillis(), request.getEndTimestampMillis(), request.getMetadataQueryMap(), request.getDimensionsQueryMap(), request.getIncludePayloads(), request.getAscending(), request.getLimit());
            if (!results.isEmpty()) {
                responseBuilder.addAllResults(this.getProtosFromEvents(results));
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void store(StoreRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.doStore(request);
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void storeBatch(StoreRequests requests, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            for (StoreRequest request : requests.getRequestsList()) {
                this.doStore(request);
            }
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void metadata(MetadataRequest request, StreamObserver<MetadataResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            Set<String> results = this.getEvents().metadata(request.getNamespace(), request.getMetadataKey(), request.getStartTimestampMillis(), request.getEndTimestampMillis(), request.getMetadataQueryMap(), request.getDimensionsQueryMap());
            MetadataResponse response = MetadataResponse.newBuilder().addAllValues(results).build();
            GrpcUtils.sendResponse(responseObserver, response);
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void dimension(DimensionRequest request, StreamObserver<DimensionResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            List<Events.Event> results = this.getEvents().dimension(request.getNamespace(), request.getDimensionKey(), request.getStartTimestampMillis(), request.getEndTimestampMillis(), request.getMetadataQueryMap(), request.getDimensionsQueryMap());
            DimensionResponse response = DimensionResponse.newBuilder().addAllValues(this.getProtosFromEvents(results)).build();
            GrpcUtils.sendResponse(responseObserver, response);
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void expire(ExpireRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getEvents().expire(request.getNamespace(), request.getEndTimestampMillis());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    private Events getEvents() {
        return this.cantor.events();
    }

    private void doStore(StoreRequest request) throws IOException {
        ArrayList<Events.Event> batch = new ArrayList<Events.Event>();
        for (EventProto eventProto : request.getBatchList()) {
            batch.add(new Events.Event(eventProto.getTimestampMillis(), eventProto.getMetadataMap(), eventProto.getDimensionsMap(), eventProto.getPayload().toByteArray()));
        }
        this.getEvents().store(request.getNamespace(), batch);
    }

    private List<EventProto> getProtosFromEvents(List<Events.Event> events) {
        ArrayList<EventProto> eventProtos = new ArrayList<EventProto>();
        for (Events.Event event : events) {
            eventProtos.add(EventProto.newBuilder().setTimestampMillis(event.getTimestampMillis()).putAllMetadata(event.getMetadata()).putAllDimensions(event.getDimensions()).setPayload(event.getPayload() != null ? ByteString.copyFrom(event.getPayload()) : ByteString.EMPTY).build());
        }
        return eventProtos;
    }
}

