/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.common.ObjectsPreconditions;
import com.salesforce.cantor.grpc.AbstractBaseGrpcClient;
import com.salesforce.cantor.grpc.objects.CreateRequest;
import com.salesforce.cantor.grpc.objects.DeleteRequest;
import com.salesforce.cantor.grpc.objects.DropRequest;
import com.salesforce.cantor.grpc.objects.GetRequest;
import com.salesforce.cantor.grpc.objects.GetResponse;
import com.salesforce.cantor.grpc.objects.KeysRequest;
import com.salesforce.cantor.grpc.objects.KeysResponse;
import com.salesforce.cantor.grpc.objects.ObjectsServiceGrpc;
import com.salesforce.cantor.grpc.objects.SizeRequest;
import com.salesforce.cantor.grpc.objects.StoreRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ObjectsOnGrpc
extends AbstractBaseGrpcClient<ObjectsServiceGrpc.ObjectsServiceBlockingStub>
implements Objects {
    public ObjectsOnGrpc(String target) {
        super(ObjectsServiceGrpc::newBlockingStub, target);
    }

    @Override
    public void create(String namespace) throws IOException {
        ObjectsPreconditions.checkCreate(namespace);
        this.call(() -> {
            CreateRequest request = CreateRequest.newBuilder().setNamespace(namespace).build();
            ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).create(request);
            return null;
        });
    }

    @Override
    public void drop(String namespace) throws IOException {
        ObjectsPreconditions.checkDrop(namespace);
        this.call(() -> {
            DropRequest request = DropRequest.newBuilder().setNamespace(namespace).build();
            ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).drop(request);
            return null;
        });
    }

    @Override
    public Collection<String> keys(String namespace, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        return this.call(() -> {
            KeysRequest request = KeysRequest.newBuilder().setNamespace(namespace).setStart(start).setCount(count).build();
            KeysResponse response = ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).keys(request);
            return response.getKeysList();
        });
    }

    @Override
    public Collection<String> keys(String namespace, String prefix, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count, prefix);
        return this.call(() -> {
            KeysRequest request = KeysRequest.newBuilder().setNamespace(namespace).setStart(start).setCount(count).setPrefix(prefix).build();
            KeysResponse response = ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).keys(request);
            return response.getKeysList();
        });
    }

    @Override
    public void store(String namespace, String key, byte[] bytes) throws IOException {
        CommonPreconditions.checkString(key, "null/empty key");
        CommonPreconditions.checkArgument(bytes != null, "null bytes");
        this.call(() -> {
            StoreRequest request = StoreRequest.newBuilder().setNamespace(namespace).setKey(key).setValue(ByteString.copyFrom(bytes)).build();
            ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).store(request);
            return null;
        });
    }

    @Override
    public void store(String namespace, Map<String, byte[]> batch) throws IOException {
        CommonPreconditions.checkArgument(batch != null, "null batch");
        this.call(() -> {
            for (Map.Entry entry : batch.entrySet()) {
                this.store(namespace, (String)entry.getKey(), (byte[])entry.getValue());
            }
            return null;
        });
    }

    @Override
    public byte[] get(String namespace, String key) throws IOException {
        CommonPreconditions.checkString(key, "null/empty key");
        return this.call(() -> {
            GetRequest request = GetRequest.newBuilder().setNamespace(namespace).setKey(key).build();
            GetResponse response = ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).get(request);
            if (response == null || response.getIsNull()) {
                return null;
            }
            return response.getValue().toByteArray();
        });
    }

    @Override
    public Map<String, byte[]> get(String namespace, Collection<String> keys) throws IOException {
        CommonPreconditions.checkArgument(keys != null, "null entries");
        return this.call(() -> {
            HashMap<String, byte[]> results = new HashMap<String, byte[]>();
            for (String key : keys) {
                results.put(key, this.get(namespace, key));
            }
            return results;
        });
    }

    @Override
    public boolean delete(String namespace, String key) throws IOException {
        CommonPreconditions.checkString(key, "null/empty key");
        return this.call(() -> {
            DeleteRequest request = DeleteRequest.newBuilder().setNamespace(namespace).setKey(key).build();
            return ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).delete(request).getResult();
        });
    }

    @Override
    public void delete(String namespace, Collection<String> keys) throws IOException {
        CommonPreconditions.checkArgument(keys != null, "null entries");
        this.call(() -> {
            for (String key : keys) {
                this.delete(namespace, key);
            }
            return null;
        });
    }

    @Override
    public int size(String namespace) throws IOException {
        return this.call(() -> {
            SizeRequest request = SizeRequest.newBuilder().setNamespace(namespace).build();
            return ((ObjectsServiceGrpc.ObjectsServiceBlockingStub)this.getStub()).size(request).getSize();
        });
    }
}

