/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.grpc.GrpcUtils;
import com.salesforce.cantor.grpc.sets.AddBatchRequest;
import com.salesforce.cantor.grpc.sets.AddRequest;
import com.salesforce.cantor.grpc.sets.CreateRequest;
import com.salesforce.cantor.grpc.sets.DeleteBatchRequest;
import com.salesforce.cantor.grpc.sets.DeleteBetweenRequest;
import com.salesforce.cantor.grpc.sets.DeleteEntryRequest;
import com.salesforce.cantor.grpc.sets.DeleteEntryResponse;
import com.salesforce.cantor.grpc.sets.DropRequest;
import com.salesforce.cantor.grpc.sets.GetRequest;
import com.salesforce.cantor.grpc.sets.GetResponse;
import com.salesforce.cantor.grpc.sets.IncRequest;
import com.salesforce.cantor.grpc.sets.IncResponse;
import com.salesforce.cantor.grpc.sets.IntersectRequest;
import com.salesforce.cantor.grpc.sets.IntersectResponse;
import com.salesforce.cantor.grpc.sets.KeysRequest;
import com.salesforce.cantor.grpc.sets.KeysResponse;
import com.salesforce.cantor.grpc.sets.PopRequest;
import com.salesforce.cantor.grpc.sets.PopResponse;
import com.salesforce.cantor.grpc.sets.SetsRequest;
import com.salesforce.cantor.grpc.sets.SetsResponse;
import com.salesforce.cantor.grpc.sets.SetsServiceGrpc;
import com.salesforce.cantor.grpc.sets.SizeRequest;
import com.salesforce.cantor.grpc.sets.SizeResponse;
import com.salesforce.cantor.grpc.sets.UnionRequest;
import com.salesforce.cantor.grpc.sets.UnionResponse;
import com.salesforce.cantor.grpc.sets.VoidResponse;
import com.salesforce.cantor.grpc.sets.WeightRequest;
import com.salesforce.cantor.grpc.sets.WeightResponse;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class SetsGrpcService
extends SetsServiceGrpc.SetsServiceImplBase {
    private final Cantor cantor;

    public SetsGrpcService(Cantor cantor) {
        CommonPreconditions.checkArgument(cantor != null, "null cantor");
        this.cantor = cantor;
    }

    @Override
    public void create(CreateRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getSets().create(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void drop(DropRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getSets().drop(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void get(GetRequest request, StreamObserver<GetResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            GetResponse.Builder responseBuilder = GetResponse.newBuilder();
            Map<String, Long> results = this.getSets().get(request.getNamespace(), request.getSet(), request.getMin(), request.getMax(), request.getStart(), request.getCount(), request.getAscending());
            if (!results.isEmpty()) {
                responseBuilder.putAllEntries(results);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void union(UnionRequest request, StreamObserver<UnionResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            UnionResponse.Builder responseBuilder = UnionResponse.newBuilder();
            Map<String, Long> results = this.getSets().union(request.getNamespace(), request.getSetsList(), request.getMin(), request.getMax(), request.getStart(), request.getCount(), request.getAscending());
            if (!results.isEmpty()) {
                responseBuilder.putAllEntries(results);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void intersect(IntersectRequest request, StreamObserver<IntersectResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            IntersectResponse.Builder responseBuilder = IntersectResponse.newBuilder();
            Map<String, Long> results = this.getSets().intersect(request.getNamespace(), request.getSetsList(), request.getMin(), request.getMax(), request.getStart(), request.getCount(), request.getAscending());
            if (!results.isEmpty()) {
                responseBuilder.putAllEntries(results);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void pop(PopRequest request, StreamObserver<PopResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            PopResponse.Builder responseBuilder = PopResponse.newBuilder();
            Map<String, Long> results = this.getSets().pop(request.getNamespace(), request.getSet(), request.getMin(), request.getMax(), request.getStart(), request.getCount(), request.getAscending());
            if (!results.isEmpty()) {
                responseBuilder.putAllEntries(results);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void add(AddRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getSets().add(request.getNamespace(), request.getSet(), request.getEntry(), request.getWeight());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void addBatch(AddBatchRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getSets().add(request.getNamespace(), request.getSet(), request.getEntriesMap());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void deleteBetween(DeleteBetweenRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getSets().delete(request.getNamespace(), request.getSet(), request.getMin(), request.getMax());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void deleteEntry(DeleteEntryRequest request, StreamObserver<DeleteEntryResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            boolean deleted = this.getSets().delete(request.getNamespace(), request.getSet(), request.getEntry());
            GrpcUtils.sendResponse(responseObserver, DeleteEntryResponse.newBuilder().setDeleted(deleted).build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void deleteBatch(DeleteBatchRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getSets().delete(request.getNamespace(), request.getSet(), request.getEntriesList());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void keys(KeysRequest request, StreamObserver<KeysResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            KeysResponse.Builder responseBuilder = KeysResponse.newBuilder();
            Collection<String> keys = this.getSets().entries(request.getNamespace(), request.getSet(), request.getMin(), request.getMax(), request.getStart(), request.getCount(), request.getAscending());
            if (!keys.isEmpty()) {
                responseBuilder.addAllKeys(keys);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void sets(SetsRequest request, StreamObserver<SetsResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            SetsResponse.Builder responseBuilder = SetsResponse.newBuilder();
            Collection<String> sets = this.getSets().sets(request.getNamespace());
            if (!sets.isEmpty()) {
                responseBuilder.addAllSets(sets);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void size(SizeRequest request, StreamObserver<SizeResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            int size = this.getSets().size(request.getNamespace(), request.getSet());
            GrpcUtils.sendResponse(responseObserver, SizeResponse.newBuilder().setSize(size).build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void weight(WeightRequest request, StreamObserver<WeightResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            Long weight = this.getSets().weight(request.getNamespace(), request.getSet(), request.getEntry());
            WeightResponse.Builder responseBuilder = WeightResponse.newBuilder();
            if (weight == null) {
                responseBuilder.setFound(false);
            } else {
                responseBuilder.setFound(true);
                responseBuilder.setWeight(weight);
            }
            GrpcUtils.sendResponse(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void inc(IncRequest request, StreamObserver<IncResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            long result = this.getSets().inc(request.getNamespace(), request.getSet(), request.getEntry(), request.getCount());
            GrpcUtils.sendResponse(responseObserver, IncResponse.newBuilder().setResult(result).build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    private Sets getSets() {
        return this.cantor.sets();
    }
}

