/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.grpc.AbstractBaseGrpcClient;
import com.salesforce.cantor.grpc.sets.AddBatchRequest;
import com.salesforce.cantor.grpc.sets.AddRequest;
import com.salesforce.cantor.grpc.sets.CreateRequest;
import com.salesforce.cantor.grpc.sets.DeleteBatchRequest;
import com.salesforce.cantor.grpc.sets.DeleteBetweenRequest;
import com.salesforce.cantor.grpc.sets.DeleteEntryRequest;
import com.salesforce.cantor.grpc.sets.DropRequest;
import com.salesforce.cantor.grpc.sets.GetRequest;
import com.salesforce.cantor.grpc.sets.IncRequest;
import com.salesforce.cantor.grpc.sets.IncResponse;
import com.salesforce.cantor.grpc.sets.IntersectRequest;
import com.salesforce.cantor.grpc.sets.KeysRequest;
import com.salesforce.cantor.grpc.sets.PopRequest;
import com.salesforce.cantor.grpc.sets.SetsRequest;
import com.salesforce.cantor.grpc.sets.SetsServiceGrpc;
import com.salesforce.cantor.grpc.sets.SizeRequest;
import com.salesforce.cantor.grpc.sets.UnionRequest;
import com.salesforce.cantor.grpc.sets.WeightRequest;
import com.salesforce.cantor.grpc.sets.WeightResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class SetsOnGrpc
extends AbstractBaseGrpcClient<SetsServiceGrpc.SetsServiceBlockingStub>
implements Sets {
    public SetsOnGrpc(String target) {
        super(SetsServiceGrpc::newBlockingStub, target);
    }

    @Override
    public void create(String namespace) throws IOException {
        SetsPreconditions.checkCreate(namespace);
        this.call(() -> {
            CreateRequest request = CreateRequest.newBuilder().setNamespace(namespace).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).create(request);
            return null;
        });
    }

    @Override
    public void drop(String namespace) throws IOException {
        SetsPreconditions.checkDrop(namespace);
        this.call(() -> {
            DropRequest request = DropRequest.newBuilder().setNamespace(namespace).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).drop(request);
            return null;
        });
    }

    @Override
    public Map<String, Long> get(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet(namespace, set, min2, max, start, count, ascending);
        return this.call(() -> {
            GetRequest request = GetRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min2).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).get(request).getEntriesMap();
        });
    }

    @Override
    public Map<String, Long> union(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion(namespace, sets, min2, max, start, count, ascending);
        return this.call(() -> {
            UnionRequest request = UnionRequest.newBuilder().setNamespace(namespace).addAllSets(sets).setMin(min2).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).union(request).getEntriesMap();
        });
    }

    @Override
    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect(namespace, sets, min2, max, start, count, ascending);
        return this.call(() -> {
            IntersectRequest request = IntersectRequest.newBuilder().setNamespace(namespace).addAllSets(sets).setMin(min2).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).intersect(request).getEntriesMap();
        });
    }

    @Override
    public Map<String, Long> pop(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop(namespace, set, min2, max, start, count, ascending);
        return this.call(() -> {
            PopRequest request = PopRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min2).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).pop(request).getEntriesMap();
        });
    }

    @Override
    public void add(String namespace, String set, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entry, weight);
        this.call(() -> {
            AddRequest request = AddRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).setWeight(weight).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).add(request);
            return null;
        });
    }

    @Override
    public void add(String namespace, String set, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entries);
        this.call(() -> {
            AddBatchRequest request = AddBatchRequest.newBuilder().setNamespace(namespace).setSet(set).putAllEntries(entries).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).addBatch(request);
            return null;
        });
    }

    @Override
    public void delete(String namespace, String set, long min2, long max) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, min2, max);
        this.call(() -> {
            DeleteBetweenRequest request = DeleteBetweenRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min2).setMax(max).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).deleteBetween(request);
            return null;
        });
    }

    @Override
    public boolean delete(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entry);
        return this.call(() -> {
            DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).deleteEntry(request).getDeleted();
        });
    }

    @Override
    public void delete(String namespace, String set, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entries);
        this.call(() -> {
            DeleteBatchRequest request = DeleteBatchRequest.newBuilder().setNamespace(namespace).setSet(set).addAllEntries(entries).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).deleteBatch(request);
            return null;
        });
    }

    @Override
    public Collection<String> entries(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkKeys(namespace, set, min2, max, start, count, ascending);
        return this.call(() -> {
            KeysRequest request = KeysRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min2).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).keys(request).getKeysList();
        });
    }

    @Override
    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets(namespace);
        return this.call(() -> {
            SetsRequest request = SetsRequest.newBuilder().setNamespace(namespace).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).sets(request).getSetsList();
        });
    }

    @Override
    public int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize(namespace, set);
        return this.call(() -> {
            SizeRequest request = SizeRequest.newBuilder().setNamespace(namespace).setSet(set).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).size(request).getSize();
        });
    }

    @Override
    public Long weight(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkWeight(namespace, set, entry);
        return this.call(() -> {
            WeightRequest request = WeightRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).build();
            WeightResponse response = ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).weight(request);
            return response.getFound() ? Long.valueOf(response.getWeight()) : null;
        });
    }

    @Override
    public long inc(String namespace, String set, String entry, long count) throws IOException {
        SetsPreconditions.checkInc(namespace, set, entry, count);
        return this.call(() -> {
            IncRequest request = IncRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).setCount(count).build();
            IncResponse response = ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).inc(request);
            return response.getResult();
        });
    }
}

