/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.h2;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.h2.H2Utils;
import com.salesforce.cantor.jdbc.AbstractBaseSetsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import javax.sql.DataSource;

public class SetsOnH2
extends AbstractBaseSetsOnJdbc
implements Sets {
    public SetsOnH2(String path) throws IOException {
        this(H2DataSourceProvider.getDatasource(new H2DataSourceProperties().setPath(path)));
    }

    public SetsOnH2(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    @Override
    protected String getCreateInternalDatabaseSql() {
        return H2Utils.getH2CreateDatabaseSql(this.getCantorInternalDatabaseName());
    }

    @Override
    protected String getCreateDatabaseSql(String namespace) {
        return H2Utils.getH2CreateDatabaseSql(namespace);
    }

    @Override
    protected String getDropDatabaseSql(String namespace) {
        return H2Utils.getH2DropDatabaseSql(namespace);
    }

    @Override
    protected String getCreateSetsTableSql(String namespace) {
        return "CREATE TABLE IF NOT EXISTS " + this.getTableFullName(namespace, this.getSetsTableName()) + " (  " + JdbcUtils.quote(this.getSetKeyColumnName()) + " VARCHAR NOT NULL,  " + JdbcUtils.quote(this.getEntryColumnName()) + " VARCHAR NOT NULL,  " + JdbcUtils.quote(this.getWeightColumnName()) + " BIGINT,   PRIMARY KEY (" + JdbcUtils.quote(this.getSetKeyColumnName()) + ", " + JdbcUtils.quote(this.getEntryColumnName()) + "),   INDEX (" + JdbcUtils.quote(this.getSetKeyColumnName()) + "),   INDEX (" + JdbcUtils.quote(this.getWeightColumnName()) + ") ) ";
    }
}

