/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.archivable.impl;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.CantorArchiver;
import com.salesforce.cantor.misc.archivable.impl.ArchivableEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivableCantor
implements Cantor {
    private static final Logger logger = LoggerFactory.getLogger(ArchivableCantor.class);
    private final Objects objects;
    private final Sets sets;
    private final Events events;

    public ArchivableCantor(Cantor delegate, CantorArchiver archiver) {
        CommonPreconditions.checkArgument(delegate != null, "null delegate");
        CommonPreconditions.checkArgument(archiver != null, "null archiver");
        logger.info("new instance of archivable cantor created");
        this.objects = delegate.objects();
        this.sets = delegate.sets();
        this.events = new ArchivableEvents(delegate.events(), archiver.events());
    }

    @Override
    public Objects objects() {
        return this.objects;
    }

    @Override
    public Sets sets() {
        return this.sets;
    }

    @Override
    public Events events() {
        return this.events;
    }
}

