/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.async;

import com.salesforce.cantor.Objects;
import com.salesforce.cantor.common.ObjectsPreconditions;
import com.salesforce.cantor.misc.async.AbstractBaseAsyncNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class AsyncObjects
extends AbstractBaseAsyncNamespaceable<Objects>
implements Objects {
    public AsyncObjects(Objects delegate, ExecutorService executorService) {
        super(delegate, executorService);
    }

    @Override
    public void create(String namespace) throws IOException {
        ObjectsPreconditions.checkCreate(namespace);
        this.submitCall(() -> {
            ((Objects)this.getDelegate()).create(namespace);
            return null;
        });
    }

    @Override
    public void drop(String namespace) throws IOException {
        ObjectsPreconditions.checkDrop(namespace);
        this.submitCall(() -> {
            ((Objects)this.getDelegate()).drop(namespace);
            return null;
        });
    }

    @Override
    public void store(String namespace, String key, byte[] bytes) throws IOException {
        ObjectsPreconditions.checkStore(namespace, key, bytes);
        ((Objects)this.getDelegate()).store(namespace, key, bytes);
        this.submitCall(() -> {
            ((Objects)this.getDelegate()).create(namespace);
            return null;
        });
    }

    @Override
    public void store(String namespace, Map<String, byte[]> batch) throws IOException {
        ObjectsPreconditions.checkStore(namespace, batch);
        this.submitCall(() -> {
            ((Objects)this.getDelegate()).store(namespace, batch);
            return null;
        });
    }

    @Override
    public byte[] get(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkGet(namespace, key);
        return this.submitCall(() -> ((Objects)this.getDelegate()).get(namespace, key));
    }

    @Override
    public Map<String, byte[]> get(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkGet(namespace, keys);
        return this.submitCall(() -> ((Objects)this.getDelegate()).get(namespace, keys));
    }

    @Override
    public boolean delete(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, key);
        return this.submitCall(() -> ((Objects)this.getDelegate()).delete(namespace, key));
    }

    @Override
    public void delete(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, keys);
        this.submitCall(() -> {
            ((Objects)this.getDelegate()).delete(namespace, keys);
            return null;
        });
    }

    @Override
    public Collection<String> keys(String namespace, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        return this.submitCall(() -> ((Objects)this.getDelegate()).keys(namespace, start, count));
    }

    @Override
    public Collection<String> keys(String namespace, String prefix, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count, prefix);
        return this.submitCall(() -> ((Objects)this.getDelegate()).keys(namespace, prefix, start, count));
    }

    @Override
    public int size(String namespace) throws IOException {
        ObjectsPreconditions.checkSize(namespace);
        return this.submitCall(() -> ((Objects)this.getDelegate()).size(namespace));
    }
}

