/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.loggable;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBaseLoggableNamespaceable<T extends Namespaceable>
implements Namespaceable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T delegate;

    public AbstractBaseLoggableNamespaceable(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public final void create(String namespace) throws IOException {
        CommonPreconditions.checkCreate(namespace);
        this.logCall(() -> {
            this.getDelegate().create(namespace);
            return null;
        }, "create", namespace, new Object[0]);
    }

    @Override
    public final void drop(String namespace) throws IOException {
        CommonPreconditions.checkDrop(namespace);
        this.logCall(() -> {
            this.getDelegate().drop(namespace);
            return null;
        }, "drop", namespace, new Object[0]);
    }

    <R> R logCall(Callable<R> callable, String methodName, String namespace, Object ... parameters) throws IOException {
        R r;
        long startNanos = System.nanoTime();
        try {
            r = callable.call();
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.logger.info("'{}.{}('{}', {}); time spent: {}ms", this.getClass().getSimpleName(), methodName, namespace, parameters, (System.nanoTime() - startNanos) / 1000000L);
                throw throwable;
            }
        }
        this.logger.info("'{}.{}('{}', {}); time spent: {}ms", this.getClass().getSimpleName(), methodName, namespace, parameters, (System.nanoTime() - startNanos) / 1000000L);
        return r;
    }

    protected T getDelegate() {
        return this.delegate;
    }
}

