/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.loggable;

import com.salesforce.cantor.Objects;
import com.salesforce.cantor.common.ObjectsPreconditions;
import com.salesforce.cantor.misc.loggable.AbstractBaseLoggableNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class LoggableObjects
extends AbstractBaseLoggableNamespaceable<Objects>
implements Objects {
    public LoggableObjects(Objects delegate) {
        super(delegate);
    }

    @Override
    public void store(String namespace, String key, byte[] bytes) throws IOException {
        ObjectsPreconditions.checkStore(namespace, key, bytes);
        ((Objects)this.getDelegate()).store(namespace, key, bytes);
        this.logCall(() -> {
            ((Objects)this.getDelegate()).create(namespace);
            return null;
        }, "store", namespace, new Object[0]);
    }

    @Override
    public void store(String namespace, Map<String, byte[]> batch) throws IOException {
        ObjectsPreconditions.checkStore(namespace, batch);
        this.logCall(() -> {
            ((Objects)this.getDelegate()).store(namespace, batch);
            return null;
        }, "store", namespace, batch.keySet());
    }

    @Override
    public byte[] get(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkGet(namespace, key);
        return this.logCall(() -> ((Objects)this.getDelegate()).get(namespace, key), "get", namespace, key);
    }

    @Override
    public Map<String, byte[]> get(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkGet(namespace, keys);
        return this.logCall(() -> ((Objects)this.getDelegate()).get(namespace, keys), "get", namespace, keys);
    }

    @Override
    public boolean delete(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, key);
        return this.logCall(() -> ((Objects)this.getDelegate()).delete(namespace, key), "delete", namespace, key);
    }

    @Override
    public void delete(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, keys);
        this.logCall(() -> {
            ((Objects)this.getDelegate()).delete(namespace, keys);
            return null;
        }, "delete", namespace, keys);
    }

    @Override
    public Collection<String> keys(String namespace, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        return this.logCall(() -> ((Objects)this.getDelegate()).keys(namespace, start, count), "keys", namespace, start, count);
    }

    @Override
    public Collection<String> keys(String namespace, String prefix, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count, prefix);
        return this.logCall(() -> ((Objects)this.getDelegate()).keys(namespace, prefix, start, count), "keys", namespace, prefix, start, count);
    }

    @Override
    public int size(String namespace) throws IOException {
        ObjectsPreconditions.checkSize(namespace);
        return this.logCall(() -> ((Objects)this.getDelegate()).size(namespace), "size", namespace, new Object[0]);
    }
}

