/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.rw;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import java.io.IOException;

abstract class AbstractBaseReadWriteNamespaceable<T extends Namespaceable>
implements Namespaceable {
    private final T writable;
    private final T readable;

    AbstractBaseReadWriteNamespaceable(T writable, T readable) {
        CommonPreconditions.checkArgument(writable != null, "null writable");
        CommonPreconditions.checkArgument(readable != null, "null readable");
        this.writable = writable;
        this.readable = readable;
    }

    @Override
    public final void create(String namespace) throws IOException {
        CommonPreconditions.checkCreate(namespace);
        this.getWritable().create(namespace);
    }

    @Override
    public final void drop(String namespace) throws IOException {
        CommonPreconditions.checkDrop(namespace);
        this.getWritable().drop(namespace);
    }

    protected T getWritable() {
        return this.writable;
    }

    protected T getReadable() {
        return this.readable;
    }
}

