/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.sharded;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBaseShardedNamespaceable<T extends Namespaceable>
implements Namespaceable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T[] delegates;

    public AbstractBaseShardedNamespaceable(T[] delegates) {
        CommonPreconditions.checkArgument(delegates != null && delegates.length > 0, "null/empty delegates");
        this.delegates = delegates;
    }

    protected T getShard(String namespace) throws IOException {
        return this.delegates[Math.abs(namespace.hashCode()) % this.delegates.length];
    }
}

