/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.sharded;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.misc.sharded.AbstractBaseShardedNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class ShardedSets
extends AbstractBaseShardedNamespaceable<Sets>
implements Sets {
    public ShardedSets(Sets ... delegates) {
        super((Namespaceable[])delegates);
    }

    @Override
    public void create(String namespace) throws IOException {
        SetsPreconditions.checkCreate(namespace);
        ((Sets)this.getShard(namespace)).create(namespace);
    }

    @Override
    public void drop(String namespace) throws IOException {
        SetsPreconditions.checkDrop(namespace);
        ((Sets)this.getShard(namespace)).drop(namespace);
    }

    @Override
    public void add(String namespace, String set, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entry, weight);
        ((Sets)this.getShard(namespace)).add(namespace, set, entry, weight);
    }

    @Override
    public void add(String namespace, String set, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entries);
        ((Sets)this.getShard(namespace)).add(namespace, set, entries);
    }

    @Override
    public Collection<String> entries(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkEntries(namespace, set, min2, max, start, count, ascending);
        return ((Sets)this.getShard(namespace)).entries(namespace, set, min2, max, start, count, ascending);
    }

    @Override
    public Map<String, Long> get(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet(namespace, set, min2, max, start, count, ascending);
        return ((Sets)this.getShard(namespace)).get(namespace, set, min2, max, start, count, ascending);
    }

    @Override
    public void delete(String namespace, String set, long min2, long max) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, min2, max);
        ((Sets)this.getShard(namespace)).delete(namespace, set, min2, max);
    }

    @Override
    public final boolean delete(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entry);
        return ((Sets)this.getShard(namespace)).delete(namespace, set, entry);
    }

    @Override
    public void delete(String namespace, String set, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entries);
        ((Sets)this.getShard(namespace)).delete(namespace, set, entries);
    }

    @Override
    public Map<String, Long> union(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion(namespace, sets, min2, max, start, count, ascending);
        return ((Sets)this.getShard(namespace)).union(namespace, sets, min2, max, start, count, ascending);
    }

    @Override
    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect(namespace, sets, min2, max, start, count, ascending);
        return ((Sets)this.getShard(namespace)).intersect(namespace, sets, min2, max, start, count, ascending);
    }

    @Override
    public Map<String, Long> pop(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop(namespace, set, min2, max, start, count, ascending);
        return ((Sets)this.getShard(namespace)).pop(namespace, set, min2, max, start, count, ascending);
    }

    @Override
    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets(namespace);
        return ((Sets)this.getShard(namespace)).sets(namespace);
    }

    @Override
    public final int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize(namespace, set);
        return ((Sets)this.getShard(namespace)).size(namespace, set);
    }

    @Override
    public Long weight(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkWeight(namespace, set, entry);
        return ((Sets)this.getShard(namespace)).weight(namespace, set, entry);
    }

    @Override
    public long inc(String namespace, String set, String entry, long count) throws IOException {
        SetsPreconditions.checkInc(namespace, set, entry, count);
        return ((Sets)this.getShard(namespace)).inc(namespace, set, entry, count);
    }
}

