/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.mysql;

import com.salesforce.cantor.Objects;
import com.salesforce.cantor.jdbc.AbstractBaseObjectsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.salesforce.cantor.mysql.MysqlDataSourceProvider;
import java.io.IOException;
import javax.sql.DataSource;

public class ObjectsOnMysql
extends AbstractBaseObjectsOnJdbc
implements Objects {
    public ObjectsOnMysql(String hostname, int port, String username, String password) throws IOException {
        this(MysqlDataSourceProvider.getDatasource(new MysqlDataSourceProperties().setHostname(hostname).setPort(port).setUsername(username).setPassword(password)));
    }

    public ObjectsOnMysql(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    @Override
    protected String getCreateObjectsTableSql(String namespace) {
        return "CREATE TABLE IF NOT EXISTS " + this.getTableFullName(namespace, this.getObjectsTableName()) + "( " + JdbcUtils.quote(this.getKeyColumnName()) + " VARCHAR(256) NOT NULL, " + JdbcUtils.quote(this.getValueColumnName()) + " LONGBLOB NOT NULL,  PRIMARY KEY (" + JdbcUtils.quote(this.getKeyColumnName()) + "),  UNIQUE INDEX (" + JdbcUtils.quote(this.getKeyColumnName()) + ") )  ENGINE=InnoDB DEFAULT CHARSET=binary PARTITION BY KEY(" + JdbcUtils.quote(this.getKeyColumnName()) + ") PARTITIONS 10";
    }
}

