/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.server;

import com.salesforce.cantor.server.CantorEnvironment;
import com.salesforce.cantor.server.grpc.GrpcServer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            Application.printUsage();
            return;
        }
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        String configPath = args[0];
        logger.info("loading configs from {}", (Object)configPath);
        Config cantorProperties = ConfigFactory.parseFile(new File(configPath)).resolve();
        logger.info("configs are: {}", (Object)cantorProperties);
        CantorEnvironment environment = new CantorEnvironment(cantorProperties);
        Application.printCantor();
        if (environment.getConfigAsInteger("grpc.port", -1) != -1) {
            logger.info("'cantor.grpc.port' is set. setting up grpc server...");
            GrpcServer grpcServer = new GrpcServer(environment);
            grpcServer.start().join();
        } else {
            logger.info("'cantor.grpc.port' not set. will not attempt to set up grpc server.");
        }
        SLF4JBridgeHandler.install();
    }

    private static void printUsage() {
        System.err.println("usage: java -jar cantor-server.jar <path-to-config>");
    }

    private static void printCantor() {
        logger.info("\n\n--- starting cantor ---\n\n");
    }
}

