/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.server.utils;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.h2.CantorOnH2;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.misc.async.AsyncCantor;
import com.salesforce.cantor.misc.loggable.LoggableCantor;
import com.salesforce.cantor.misc.rw.ReadWriteCantor;
import com.salesforce.cantor.misc.sharded.ShardedCantor;
import com.salesforce.cantor.mysql.CantorOnMysql;
import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.salesforce.cantor.mysql.MysqlDataSourceProvider;
import com.salesforce.cantor.s3.CantorOnS3;
import com.salesforce.cantor.server.CantorEnvironment;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CantorFactory {
    private static final Logger logger = LoggerFactory.getLogger(CantorFactory.class);
    private static final String ENV_MYSQL_SHARDS = "MYSQL_SHARDS";
    private final CantorEnvironment cantorEnvironment;

    public CantorFactory(CantorEnvironment cantorEnvironment) {
        this.cantorEnvironment = cantorEnvironment;
    }

    public Cantor getCantor() throws IOException {
        String storageType = this.cantorEnvironment.getStorageType();
        if (storageType.equalsIgnoreCase("s3")) {
            Config config = this.cantorEnvironment.getConfig(storageType);
            if (!config.hasPath("sets.type")) {
                throw new IllegalArgumentException("Missing configuration setting for 's3.sets.type'");
            }
            logger.info("creating s3 cantor instance with sets on {}...", (Object)config.getString("sets.type"));
            String bucketName = config.getString("bucket");
            if (Strings.isNullOrEmpty(bucketName)) {
                throw new IllegalArgumentException("Bucket name invalid. Please set 's3.bucket'");
            }
            final Sets sets = this.getCantorByType(config.getString("sets.type")).sets();
            return new LoggableCantor(new CantorOnS3(this.createAwsClient(config), bucketName){

                @Override
                public Sets sets() {
                    return sets;
                }
            });
        }
        return this.getCantorByType(storageType);
    }

    private Cantor getCantorByType(String storageType) throws IOException {
        if (storageType.equalsIgnoreCase("mysql")) {
            String mysqlShards = this.cantorEnvironment.getEnvironmentVariable(ENV_MYSQL_SHARDS);
            List<MysqlDataSourceProperties> dataSources = mysqlShards != null ? this.getMysqlFromEnv(mysqlShards) : this.getMysqlDataSourceProperties(this.cantorEnvironment.getConfigAsList(storageType));
            if (dataSources.size() == 1) {
                logger.info("creating single instance mysql cantor...");
                CantorOnMysql readCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(0)));
                CantorOnMysql writeCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(0)));
                return new LoggableCantor(new AsyncCantor(new ReadWriteCantor(writeCantor, readCantor), this.newExecutorService()));
            }
            Cantor[] cantors = new Cantor[dataSources.size()];
            for (int index = 0; index < cantors.length; ++index) {
                CantorOnMysql readCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(index)));
                CantorOnMysql writeCantor = new CantorOnMysql(MysqlDataSourceProvider.getDatasource(dataSources.get(index)));
                cantors[index] = new AsyncCantor(new ReadWriteCantor(writeCantor, readCantor), this.newExecutorService());
            }
            logger.info("creating shared mysql cantor with {} instances: {}", (Object)cantors.length, (Object)dataSources);
            return new LoggableCantor(new ShardedCantor(cantors));
        }
        if (storageType.equalsIgnoreCase("h2")) {
            List<H2DataSourceProperties> dataSources = this.getH2DataSourceProperties(this.cantorEnvironment.getConfigAsList(storageType));
            if (dataSources.size() == 1) {
                logger.info("creating single instance h2 cantor...");
                return new LoggableCantor(new CantorOnH2(H2DataSourceProvider.getDatasource(dataSources.get(0))));
            }
            Cantor[] cantors = new Cantor[dataSources.size()];
            for (int index = 0; index < cantors.length; ++index) {
                cantors[index] = new CantorOnH2(H2DataSourceProvider.getDatasource(dataSources.get(index)));
            }
            logger.info("creating shared h2 cantor with {} instances: {}", (Object)cantors.length, (Object)dataSources);
            return new LoggableCantor(new ShardedCantor(cantors));
        }
        throw new IllegalArgumentException("invalid storage type");
    }

    private List<MysqlDataSourceProperties> getMysqlFromEnv(String mysqlShardsString) {
        String[] mysqlShards;
        ArrayList<MysqlDataSourceProperties> propertiesList = new ArrayList<MysqlDataSourceProperties>();
        for (String mysqlShard : mysqlShards = mysqlShardsString.split(",")) {
            String[] hostPort = mysqlShard.split(":");
            if (hostPort.length != 2) {
                throw new IllegalArgumentException("MYSQL_SHARDS is in an invalid format. Expected: <hostname1>:<port1>,<hostname2>:<port2>,... Found: " + mysqlShardsString);
            }
            MysqlDataSourceProperties properties = new MysqlDataSourceProperties();
            properties.setHostname(hostPort[0]);
            properties.setPort(Integer.parseInt(hostPort[1]));
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    private List<MysqlDataSourceProperties> getMysqlDataSourceProperties(List<? extends Config> configObjects) {
        ArrayList<MysqlDataSourceProperties> propertiesList = new ArrayList<MysqlDataSourceProperties>();
        for (Config config : configObjects) {
            MysqlDataSourceProperties properties = new MysqlDataSourceProperties();
            properties.setHostname(config.getString("hostname"));
            properties.setPort(config.getInt("port"));
            properties.setUsername(config.getString("username"));
            properties.setPassword(config.getString("password"));
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    private List<H2DataSourceProperties> getH2DataSourceProperties(List<? extends Config> configObjects) {
        ArrayList<H2DataSourceProperties> propertiesList = new ArrayList<H2DataSourceProperties>();
        for (Config config : configObjects) {
            H2DataSourceProperties properties = new H2DataSourceProperties();
            properties.setPath(config.getString("path"));
            properties.setInMemory(config.getBoolean("in-memory"));
            properties.setCompressed(config.getBoolean("compressed"));
            properties.setUsername(config.getString("username"));
            properties.setPassword(config.getString("password"));
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    private AmazonS3 createAwsClient(Config config) {
        int proxyPort;
        boolean endpointOverride;
        String region = config.getString("region");
        AmazonS3ClientBuilder amazonS3ClientBuilder = AmazonS3ClientBuilder.standard();
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.withProtocol(Protocol.HTTPS).withMaxConnections(256).withConnectionMaxIdleMillis(TimeUnit.MINUTES.toMillis(5L)).withConnectionTimeout(3000).withRequestTimeout(10000).withMaxErrorRetry(3);
        boolean bl = endpointOverride = config.hasPath("endpoint.override") && config.getBoolean("endpoint.override");
        if (endpointOverride) {
            amazonS3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(String.format("%s-fips", region), region));
        } else {
            amazonS3ClientBuilder.withRegion(region);
        }
        String proxyHost = config.hasPath("proxy.host") ? config.getString("proxy.host") : "";
        int n = proxyPort = config.hasPath("proxy.port") ? config.getInt("proxy.port") : -1;
        if (!Strings.isNullOrEmpty(proxyHost)) {
            clientConfiguration.setProxyHost(proxyHost);
            clientConfiguration.setProxyPort(proxyPort);
        }
        return (AmazonS3)((AmazonS3ClientBuilder)amazonS3ClientBuilder.withClientConfiguration(clientConfiguration)).build();
    }

    private ExecutorService newExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("cantor-worker-%d").build());
    }
}

