/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.common;

import com.salesforce.cantor.common.CommonPreconditions;
import java.util.Collection;
import java.util.Map;

public class SetsPreconditions
extends CommonPreconditions {
    public static void checkGet(String namespace, String set, long min2, long max, int start, int count, boolean ascendingIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
        SetsPreconditions.checkArgument(start >= 0, "invalid start");
        SetsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkUnion(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascendingIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkArgument(sets != null && !sets.isEmpty(), "null/empty sets");
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
        SetsPreconditions.checkArgument(start >= 0, "invalid start");
        SetsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkIntersect(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascendingIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkArgument(sets != null && !sets.isEmpty(), "null/empty sets");
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
        SetsPreconditions.checkArgument(start >= 0, "invalid start");
        SetsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkPop(String namespace, String set, long min2, long max, int start, int count, boolean ascendingIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
        SetsPreconditions.checkArgument(start >= 0, "invalid start");
        SetsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkAdd(String namespace, String set, String entry, long weightIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkString(entry);
    }

    public static void checkAdd(String namespace, String set, Map<String, Long> entries) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(entries != null, "null entries");
    }

    public static void checkDelete(String namespace, String set, long min2, long max) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
    }

    public static void checkDelete(String namespace, String set, String entry) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkString(entry);
    }

    public static void checkDelete(String namespace, String set, Collection<String> entries) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(entries != null, "null entries");
    }

    public static void checkSets(String namespace) {
        SetsPreconditions.checkNamespace(namespace);
    }

    public static void checkEntries(String namespace, String set, long min2, long max, int start, int count, boolean ascendingIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
        SetsPreconditions.checkArgument(start >= 0, "invalid start");
        SetsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkKeys(String namespace, String set, long min2, long max, int start, int count, boolean ascendingIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkArgument(min2 <= max, "invalid min/max");
        SetsPreconditions.checkArgument(start >= 0, "invalid start");
        SetsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkSize(String namespace, String set) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
    }

    public static void checkWeight(String namespace, String set, String entry) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkString(entry);
    }

    public static void checkInc(String namespace, String set, String entry, long countIgnored) {
        SetsPreconditions.checkNamespace(namespace);
        SetsPreconditions.checkString(set);
        SetsPreconditions.checkString(entry);
    }
}

