/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.common.CommonUtils;
import com.salesforce.cantor.common.EventsPreconditions;
import com.salesforce.cantor.grpc.AbstractBaseGrpcClient;
import com.salesforce.cantor.grpc.events.CreateRequest;
import com.salesforce.cantor.grpc.events.DimensionRequest;
import com.salesforce.cantor.grpc.events.DimensionResponse;
import com.salesforce.cantor.grpc.events.DropRequest;
import com.salesforce.cantor.grpc.events.EventProto;
import com.salesforce.cantor.grpc.events.EventsServiceGrpc;
import com.salesforce.cantor.grpc.events.ExpireRequest;
import com.salesforce.cantor.grpc.events.GetRequest;
import com.salesforce.cantor.grpc.events.GetResponse;
import com.salesforce.cantor.grpc.events.MetadataRequest;
import com.salesforce.cantor.grpc.events.MetadataResponse;
import com.salesforce.cantor.grpc.events.StoreRequest;
import com.salesforce.cantor.grpc.events.StoreRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventsOnGrpc
extends AbstractBaseGrpcClient<EventsServiceGrpc.EventsServiceBlockingStub>
implements Events {
    public EventsOnGrpc(String target) {
        super(EventsServiceGrpc::newBlockingStub, target);
    }

    @Override
    public void create(String namespace) throws IOException {
        EventsPreconditions.checkCreate(namespace);
        this.call(() -> {
            CreateRequest request = CreateRequest.newBuilder().setNamespace(namespace).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).create(request);
            return null;
        });
    }

    @Override
    public void drop(String namespace) throws IOException {
        EventsPreconditions.checkDrop(namespace);
        this.call(() -> {
            DropRequest request = DropRequest.newBuilder().setNamespace(namespace).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).drop(request);
            return null;
        });
    }

    @Override
    public void store(String namespace, Collection<Events.Event> batch) throws IOException {
        EventsPreconditions.checkStore(namespace, batch);
        this.call(() -> {
            ArrayList<EventProto> eventBatch = new ArrayList<EventProto>();
            for (Events.Event event : batch) {
                eventBatch.add(EventProto.newBuilder().setTimestampMillis(event.getTimestampMillis()).putAllMetadata(event.getMetadata()).putAllDimensions(event.getDimensions()).setPayload(event.getPayload() != null ? ByteString.copyFrom(event.getPayload()) : ByteString.EMPTY).build());
            }
            StoreRequest request = StoreRequest.newBuilder().setNamespace(namespace).addAllBatch(eventBatch).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).store(request);
            return null;
        });
    }

    public void store(Map<String, Collection<Events.Event>> batch) throws IOException {
        for (Map.Entry<String, Collection<Events.Event>> entry : batch.entrySet()) {
            EventsPreconditions.checkStore(entry.getKey(), entry.getValue());
        }
        this.call(() -> {
            ArrayList<EventProto> eventBatch = new ArrayList<EventProto>();
            StoreRequests.Builder requestsBuilder = StoreRequests.newBuilder();
            for (Map.Entry entry : batch.entrySet()) {
                String namespace = (String)entry.getKey();
                for (Events.Event event : (Collection)entry.getValue()) {
                    eventBatch.add(EventProto.newBuilder().setTimestampMillis(event.getTimestampMillis()).putAllMetadata(event.getMetadata()).putAllDimensions(event.getDimensions()).setPayload(event.getPayload() != null ? ByteString.copyFrom(event.getPayload()) : ByteString.EMPTY).build());
                }
                StoreRequest request = StoreRequest.newBuilder().setNamespace(namespace).addAllBatch(eventBatch).build();
                requestsBuilder.addRequests(request);
            }
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).storeBatch(requestsBuilder.build());
            return null;
        });
    }

    @Override
    public List<Events.Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        EventsPreconditions.checkGet(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.call(() -> {
            GetRequest request = GetRequest.newBuilder().setNamespace(namespace).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty(metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty(dimensionsQuery)).setIncludePayloads(includePayloads).setAscending(ascending).setLimit(limit).build();
            GetResponse response = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).get(request);
            return this.getEventsFromProtos(response.getResultsList());
        });
    }

    @Override
    public Set<String> metadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkMetadata(namespace, metadataKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.call(() -> {
            MetadataRequest request = MetadataRequest.newBuilder().setNamespace(namespace).setMetadataKey(metadataKey).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty(metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty(dimensionsQuery)).build();
            MetadataResponse metadataResponse = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).metadata(request);
            return new HashSet<String>(metadataResponse.getValuesList());
        });
    }

    @Override
    public List<Events.Event> dimension(String namespace, String dimensionKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkDimension(namespace, dimensionKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.call(() -> {
            DimensionRequest request = DimensionRequest.newBuilder().setNamespace(namespace).setDimensionKey(dimensionKey).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty(metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty(dimensionsQuery)).build();
            DimensionResponse dimensionResponse = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).dimension(request);
            return this.getEventsFromProtos(dimensionResponse.getValuesList());
        });
    }

    @Override
    public void expire(String namespace, long endTimestampMillis) throws IOException {
        EventsPreconditions.checkExpire(namespace, endTimestampMillis);
        this.call(() -> {
            ExpireRequest request = ExpireRequest.newBuilder().setNamespace(namespace).setEndTimestampMillis(endTimestampMillis).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).expire(request);
            return null;
        });
    }

    private List<Events.Event> getEventsFromProtos(List<EventProto> eventProtos) {
        ArrayList<Events.Event> events = new ArrayList<Events.Event>();
        for (EventProto proto : eventProtos) {
            ByteString payloadByteString = proto.getPayload();
            events.add(new Events.Event(proto.getTimestampMillis(), proto.getMetadataMap(), proto.getDimensionsMap(), payloadByteString != null ? payloadByteString.toByteArray() : null));
        }
        return events;
    }
}

