/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.jdbc;

import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBaseCantorOnJdbc {
    private static final String cantorInternalDatabaseName = "cantor";
    private static final int maxQueryTimeoutSeconds = 30;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final DataSource dataSource;

    protected abstract void createInternalTables(Connection var1, String var2) throws IOException;

    protected AbstractBaseCantorOnJdbc(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected String getCantorInternalDatabaseName() {
        return cantorInternalDatabaseName;
    }

    protected abstract String getNamespaceLookupTableName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNamespace(String namespace) throws IOException {
        this.init();
        String databaseName = this.getDatabaseNameForNamespace(namespace);
        this.logger.info("creating namespace: '{}' database name: '{}'", (Object)namespace, (Object)databaseName);
        Connection connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            this.executeUpdate(connection, this.getCreateInternalDatabaseSql(), new Object[0]);
            this.executeUpdate(connection, this.getCreateNamespaceLookupTableSql(), new Object[0]);
            this.executeUpdate(connection, this.getCreateDatabaseSql(databaseName), new Object[0]);
            String sql = String.format("INSERT INTO %s.%s SET %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s = ?", JdbcUtils.quote(cantorInternalDatabaseName), JdbcUtils.quote(this.getNamespaceLookupTableName()), JdbcUtils.quote(this.getNamespaceColumnName()), JdbcUtils.quote(this.getDatabaseColumnName()), JdbcUtils.quote(this.getNamespaceColumnName()));
            this.executeUpdate(connection, sql, namespace, databaseName, namespace);
            this.createInternalTables(connection, namespace);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void init() throws IOException {
        if (!this.isInitialized.getAndSet(true)) {
            this.doCreateInternalDatabase();
            this.doValidations();
        }
    }

    private void doCreateInternalDatabase() throws IOException {
        Connection connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            this.executeUpdate(connection, this.getCreateInternalDatabaseSql(), new Object[0]);
            this.executeUpdate(connection, this.getCreateNamespaceLookupTableSql(), new Object[0]);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    protected abstract void doValidations() throws IOException;

    private String getCreateNamespaceLookupTableSql() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s (  %s VARCHAR(512) NOT NULL,  %s VARCHAR(128) NOT NULL,  PRIMARY KEY (%s, %s) ) ", JdbcUtils.quote(cantorInternalDatabaseName), JdbcUtils.quote(this.getNamespaceLookupTableName()), JdbcUtils.quote(this.getNamespaceColumnName()), JdbcUtils.quote(this.getDatabaseColumnName()), JdbcUtils.quote(this.getNamespaceColumnName()), JdbcUtils.quote(this.getDatabaseColumnName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<String> getNamespaces() throws IOException {
        this.init();
        String sql = String.format("SELECT %s FROM %s.%s", JdbcUtils.quote(this.getNamespaceColumnName()), JdbcUtils.quote(cantorInternalDatabaseName), JdbcUtils.quote(this.getNamespaceLookupTableName()));
        ArrayList<String> results = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.setQueryTimeout(30);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        results.add(resultSet.getString(1));
                    }
                }
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            this.logger.warn("exception on .namepsaces()", e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropNamespace(String namespace) throws IOException {
        this.init();
        String databaseName = this.getDatabaseNameForNamespace(namespace);
        this.logger.info("dropping namespace '{}' database name: '{}' if exists", (Object)namespace, (Object)databaseName);
        Connection connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            String dropDatabaseSql = this.getDropDatabaseSql(databaseName);
            this.executeUpdate(dropDatabaseSql, new Object[0]);
            String sql = String.format("DELETE FROM %s.%s WHERE %s = ?", JdbcUtils.quote(cantorInternalDatabaseName), JdbcUtils.quote(this.getNamespaceLookupTableName()), JdbcUtils.quote(this.getDatabaseColumnName()));
            this.executeUpdate(connection, sql, databaseName);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    protected String getDatabaseNameForNamespace(String namespace) {
        String cleanName = namespace.replaceAll("[^A-Za-z0-9_\\-/]", "").toLowerCase();
        return String.format("cantor-%s-%s", cleanName.substring(0, Math.min(32, cleanName.length())), Math.abs(namespace.hashCode()));
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected Connection getConnection() throws IOException {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            this.logger.warn("failed to get connection", e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection connection) throws IOException {
        if (connection == null) {
            return;
        }
        try {
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                this.logger.warn("exception executing commit", e);
                try {
                    connection.rollback();
                    throw new IOException("operation rolled back");
                }
                catch (SQLException rollbackexception) {
                    this.logger.warn("exception executing rollback", rollbackexception);
                    throw new IOException(e);
                }
            }
        }
        finally {
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logger.warn("exception closing connection", e);
                throw new IOException(e);
            }
        }
    }

    protected Connection openTransaction(Connection connection) throws IOException {
        try {
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException e) {
            this.logger.warn("exception opening transaction", e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String sql, Object ... parameters) throws IOException {
        Connection connection = this.getConnection();
        try {
            int n = this.executeUpdate(connection, sql, parameters);
            return n;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeUpdate(Connection connection, String sql, Object ... parameters) throws IOException {
        try {
            while (true) {
                try (PreparedStatement preparedStatement2222 = connection.prepareStatement(sql);){
                    preparedStatement2222.setQueryTimeout(30);
                    JdbcUtils.addParameters(preparedStatement2222, parameters);
                    int n = preparedStatement2222.executeUpdate();
                    return n;
                }
                catch (SQLTransactionRollbackException preparedStatement2222) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            this.logger.debug("exception caught on executing update sql: '{}'", (Object)sql);
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] executeBatchUpdate(Connection connection, String sql, Collection<Object[]> batchParameters) throws IOException {
        try {
            while (true) {
                try (PreparedStatement preparedStatement2222 = connection.prepareStatement(sql);){
                    preparedStatement2222.setQueryTimeout(30);
                    for (Object[] parameters : batchParameters) {
                        JdbcUtils.addParameters(preparedStatement2222, parameters);
                        preparedStatement2222.addBatch();
                    }
                    Object object = preparedStatement2222.executeBatch();
                    return object;
                }
                catch (SQLTransactionRollbackException preparedStatement2222) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            this.logger.debug("exception caught on executing update sql: '{}'", (Object)sql);
            throw new IOException(e);
        }
    }

    protected String getNamespaceColumnName() {
        return "NAMESPACE";
    }

    protected String getDatabaseColumnName() {
        return "DATABASE";
    }

    protected String getCreateInternalDatabaseSql() {
        return String.format("CREATE DATABASE IF NOT EXISTS %s", JdbcUtils.quote(cantorInternalDatabaseName));
    }

    protected String getCreateDatabaseSql(String database) {
        return String.format("CREATE DATABASE IF NOT EXISTS %s", JdbcUtils.quote(database));
    }

    protected String getDropDatabaseSql(String database) {
        return String.format("DROP DATABASE IF EXISTS %s", JdbcUtils.quote(database));
    }

    protected String getDropTableSql(String namespace, String tableName) {
        return String.format("DROP TABLE %s", this.getTableFullName(namespace, tableName));
    }

    protected String getTableFullName(String namespace, String tableName) {
        return String.format("%s.%s", JdbcUtils.quote(this.getDatabaseNameForNamespace(namespace)), JdbcUtils.quote(tableName));
    }
}

