/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.jdbc;

import com.salesforce.cantor.Objects;
import com.salesforce.cantor.common.ObjectsPreconditions;
import com.salesforce.cantor.jdbc.AbstractBaseCantorOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseObjectsOnJdbc
extends AbstractBaseCantorOnJdbc
implements Objects {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractBaseObjectsOnJdbc(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void create(String namespace) throws IOException {
        ObjectsPreconditions.checkCreate(namespace);
        this.createNamespace(namespace);
    }

    @Override
    public void drop(String namespace) throws IOException {
        ObjectsPreconditions.checkDrop(namespace);
        this.dropNamespace(namespace);
    }

    @Override
    public Collection<String> keys(String namespace, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        return this.doKeys(namespace, start, count);
    }

    @Override
    public Collection<String> keys(String namespace, String prefix, int start, int count) throws IOException {
        throw new UnsupportedOperationException("This functionality has not yet been implemented yet.");
    }

    @Override
    public void store(String namespace, String key, byte[] value) throws IOException {
        ObjectsPreconditions.checkStore(namespace, key, value);
        this.doStore(namespace, key, value);
    }

    @Override
    public void store(String namespace, Map<String, byte[]> batch) throws IOException {
        ObjectsPreconditions.checkStore(namespace, batch);
        this.doStore(namespace, batch);
    }

    @Override
    public byte[] get(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkGet(namespace, key);
        return this.doGet(namespace, key);
    }

    @Override
    public Map<String, byte[]> get(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkGet(namespace, keys);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.doGet(namespace, keys);
    }

    @Override
    public int size(String namespace) throws IOException {
        ObjectsPreconditions.checkSize(namespace);
        return this.doSize(namespace);
    }

    @Override
    public boolean delete(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, key);
        return this.doDelete(namespace, key);
    }

    @Override
    public void delete(String namespace, Collection<String> objects) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, objects);
        if (objects.isEmpty()) {
            return;
        }
        this.doDelete(namespace, objects);
    }

    @Override
    protected void createInternalTables(Connection connection, String namespace) throws IOException {
        this.createObjectsTable(connection, namespace);
    }

    @Override
    protected void doValidations() throws IOException {
        this.logger.info("looking for mismatch between database and objects lookup tables");
    }

    private Collection<String> doKeys(String namespace, int start, int count) throws IOException {
        String sql = String.format("SELECT %s FROM %s %s", JdbcUtils.quote(this.getKeyColumnName()), this.getTableFullName(namespace, this.getObjectsTableName()), this.getLimitString(start, count));
        ArrayList<String> results = new ArrayList<String>();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String key = resultSet.getString(1);
                results.add(key);
            }
        }
        catch (SQLException e) {
            this.logger.warn("exception on objects.keys()", e);
            throw new IOException(e);
        }
        return results;
    }

    /*
     * Exception decompiling
     */
    private byte[] doGet(String namespace, String key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, byte[]> doGet(String namespace, Collection<String> keys) throws IOException {
        String sql = String.format("SELECT %s, %s FROM %s WHERE %s IN (%s)", JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getValueColumnName()), this.getTableFullName(namespace, this.getObjectsTableName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.getPlaceholders(keys.size()));
        LinkedHashMap<String, byte[]> results = new LinkedHashMap<String, byte[]>();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int placeholderIndex = 1;
            for (String key : keys) {
                preparedStatement.setString(placeholderIndex, key);
                ++placeholderIndex;
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String key = resultSet.getString(1);
                    byte[] val = JdbcUtils.toBytes(resultSet.getBlob(2).getBinaryStream());
                    results.put(key, val);
                }
            }
        }
        catch (SQLException e) {
            this.logger.warn("exception on objects.get()", e);
            throw new IOException(e);
        }
        return results;
    }

    private void doStore(String namespace, String key, byte[] bytes) throws IOException {
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s = ?", this.getTableFullName(namespace, this.getObjectsTableName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getValueColumnName()), JdbcUtils.quote(this.getValueColumnName()));
        this.executeUpdate(sql, key, bytes, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStore(String namespace, Map<String, byte[]> objects) throws IOException {
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s = ?", this.getTableFullName(namespace, this.getObjectsTableName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getValueColumnName()), JdbcUtils.quote(this.getValueColumnName()));
        Connection connection = null;
        try {
            ArrayList<Object[]> parameters = new ArrayList<Object[]>();
            for (Map.Entry<String, byte[]> entry : objects.entrySet()) {
                parameters.add(new Object[]{entry.getKey(), entry.getValue(), entry.getValue()});
            }
            connection = this.openTransaction(this.getConnection());
            this.executeBatchUpdate(connection, sql, parameters);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
    }

    private boolean doDelete(String namespace, String key) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ?", this.getTableFullName(namespace, this.getObjectsTableName()), JdbcUtils.quote(this.getKeyColumnName()));
        return this.executeUpdate(sql, key) == 1;
    }

    private void doDelete(String namespace, Collection<String> keys) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s IN (%s)", this.getTableFullName(namespace, this.getObjectsTableName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.getPlaceholders(keys.size()));
        this.executeUpdate(sql, keys.toArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doSize(String namespace) throws IOException {
        String sql = String.format("SELECT COUNT(*) FROM %s", this.getTableFullName(namespace, this.getObjectsTableName()));
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) throw new IllegalStateException();
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.logger.warn("exception on objects.size()", e);
            throw new IOException(e);
        }
    }

    private void createObjectsTable(Connection connection, String namespace) throws IOException {
        this.logger.info("creating objects table for namespace '{}' if not exists", (Object)namespace);
        String createObjectTableSql = this.getCreateObjectsTableSql(namespace);
        this.executeUpdate(connection, createObjectTableSql, new Object[0]);
    }

    protected abstract String getCreateObjectsTableSql(String var1);

    protected String getKeyColumnName() {
        return "KEY";
    }

    protected String getValueColumnName() {
        return "VALUE";
    }

    protected String getObjectsTableName() {
        return "CANTOR-OBJECTS";
    }

    @Override
    protected String getNamespaceLookupTableName() {
        return "OBJECTS-NAMESPACES";
    }

    private String getLimitString(int start, int count) {
        if (start == 0 && count == -1) {
            return " ";
        }
        return " LIMIT " + start + "," + count;
    }
}

