/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.jdbc;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.jdbc.AbstractBaseCantorOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseSetsOnJdbc
extends AbstractBaseCantorOnJdbc
implements Sets {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractBaseSetsOnJdbc(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void create(String namespace) throws IOException {
        SetsPreconditions.checkCreate(namespace);
        this.createNamespace(namespace);
    }

    @Override
    public void drop(String namespace) throws IOException {
        SetsPreconditions.checkDrop(namespace);
        this.dropNamespace(namespace);
    }

    @Override
    public int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize(namespace, set);
        return this.doSize(namespace, set);
    }

    @Override
    public Collection<String> entries(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkEntries(namespace, set, min2, max, start, count, ascending);
        return this.doEntries(namespace, set, min2, max, start, count, this.getOrderByString(ascending));
    }

    @Override
    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets(namespace);
        return this.doSets(namespace);
    }

    @Override
    public Map<String, Long> get(String namespace, String set, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet(namespace, set, min2, max, start, count, ascending);
        return this.doGet(namespace, set, min2, max, start, count, this.getOrderByString(ascending));
    }

    @Override
    public Map<String, Long> union(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion(namespace, sets, min2, max, start, count, ascending);
        return this.doUnion(namespace, sets, min2, max, start, count, this.getOrderByString(ascending));
    }

    @Override
    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect(namespace, sets, min2, max, start, count, ascending);
        return this.doIntersect(namespace, sets, min2, max, start, count, this.getOrderByString(ascending));
    }

    @Override
    public Map<String, Long> pop(String namespace, String key, long min2, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop(namespace, key, min2, max, start, count, ascending);
        return this.doPop(namespace, key, min2, max, start, count, this.getOrderByString(ascending));
    }

    @Override
    public void delete(String namespace, String key, long min2, long max) throws IOException {
        SetsPreconditions.checkDelete(namespace, key, min2, max);
        this.doDelete(namespace, key, min2, max);
    }

    @Override
    public boolean delete(String namespace, String key, String entry) throws IOException {
        SetsPreconditions.checkDelete(namespace, key, entry);
        return this.doDelete(namespace, key, entry);
    }

    @Override
    public void delete(String namespace, String key, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete(namespace, key, entries);
        this.doDelete(namespace, key, entries);
    }

    @Override
    public void add(String namespace, String key, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd(namespace, key, entry, weight);
        this.doAdd(namespace, key, entry, weight);
    }

    @Override
    public void add(String namespace, String key, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd(namespace, key, entries);
        this.doAdd(namespace, key, entries);
    }

    @Override
    public Long weight(String namespace, String key, String entry) throws IOException {
        SetsPreconditions.checkWeight(namespace, key, entry);
        return this.doWeight(namespace, key, entry);
    }

    @Override
    public long inc(String namespace, String key, String entry, long count) throws IOException {
        SetsPreconditions.checkInc(namespace, key, entry, count);
        return this.doInc(namespace, key, entry, count);
    }

    @Override
    protected String getNamespaceLookupTableName() {
        return "SETS-NAMESPACES";
    }

    @Override
    protected void createInternalTables(Connection connection, String namespace) throws IOException {
        this.logger.info("creating sets table for namespace '{}' if not exists", (Object)namespace);
        this.executeUpdate(connection, this.getCreateSetsTableSql(namespace), new Object[0]);
    }

    @Override
    protected void doValidations() throws IOException {
        this.logger.info("looking for mismatch between database and sets lookup tables");
    }

    /*
     * Exception decompiling
     */
    private int doSize(String namespace, String set) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> doGet(String namespace, String set, long min2, long max, int start, int count, String orderby) throws IOException {
        String sql = String.format("SELECT %s, %s FROM %s WHERE %s.%s = ? AND %s.%s BETWEEN ? AND ? %s %s", JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getSetsTableName()), JdbcUtils.quote(this.getWeightColumnName()), orderby, this.getLimitString(start, count));
        LinkedHashMap<String, Long> items = new LinkedHashMap<String, Long>();
        try (Connection connection = this.getConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.setString(1, set);
                preparedStatement.setLong(2, min2);
                preparedStatement.setLong(3, max);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String key = resultSet.getString(1);
                        Long weight = resultSet.getLong(2);
                        if (key == null || key.isEmpty()) continue;
                        items.put(key, weight);
                    }
                }
            }
            LinkedHashMap<String, Long> linkedHashMap = items;
            return linkedHashMap;
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.get()", e);
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Long> doUnion(String namespace, Collection<String> sets, long min, long max, int start, int count, String orderby) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<String, Long> doIntersect(String namespace, Collection<String> sets, long min, long max, int start, int count, String orderby) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<String, Long> doPop(String namespace, String set, long min, long max, int start, int count, String orderby) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 38[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<String> doEntries(String namespace, String set, long min, long max, int start, int count, String orderby) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<String> doSets(String namespace) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doDelete(String namespace, String key, long min2, long max) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s BETWEEN ? AND ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        this.executeUpdate(sql, key, min2, max);
    }

    private boolean doDelete(String namespace, String set, String entry) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s = ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()));
        return this.executeUpdate(sql, set, entry) == 1;
    }

    private void doDelete(String namespace, String set, Collection<String> entries) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s IN (%s) ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.getPlaceholders(entries.size()));
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, set);
            int placeholderIndex = 2;
            for (String entry : entries) {
                preparedStatement.setString(placeholderIndex, entry);
                ++placeholderIndex;
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.delete()", e);
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private Long doWeight(String namespace, String set, String entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long doInc(String namespace, String set, String entry, long count) throws IOException {
        v0 = exists = this.doWeight(namespace, set, entry) != null;
        if (!exists) {
            this.doAdd(namespace, set, entry, 0L);
        }
        updateSql = String.format("UPDATE %s SET %s = %s + ? WHERE %s = ? AND %s = ? ", new Object[]{this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName())});
        selectSql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ? ", new Object[]{JdbcUtils.quote(this.getWeightColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName())});
        connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            this.executeUpdate(connection, updateSql, new Object[]{count, set, entry});
            try {
                block31: {
                    preparedStatement = connection.prepareStatement(selectSql);
                    var11_11 = null;
                    try {
                        block29: {
                            block30: {
                                preparedStatement.setString(1, set);
                                preparedStatement.setString(2, entry);
                                resultSet = preparedStatement.executeQuery();
                                var13_14 = null;
                                try {
                                    if (resultSet.next()) {
                                        var14_15 = resultSet.getLong(1);
                                        if (resultSet == null) break block29;
                                        if (var13_14 == null) break block30;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var14_16) {
                                    var13_14 = var14_16;
                                    throw var14_16;
                                }
                                catch (Throwable var17_19) {
                                    if (resultSet == null) throw var17_19;
                                    if (var13_14 == null) {
                                        resultSet.close();
                                        throw var17_19;
                                    }
                                    try {
                                        resultSet.close();
                                        throw var17_19;
                                    }
                                    catch (Throwable var18_20) {
                                        var13_14.addSuppressed(var18_20);
                                        throw var17_19;
                                    }
                                }
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable var16_17) {
                                    var13_14.addSuppressed(var16_17);
                                }
                                break block29;
                            }
                            resultSet.close();
                        }
                        if (preparedStatement == null) return var14_15;
                        if (var11_11 == null) break block31;
                    }
                    catch (Throwable var12_13) {
                        var11_11 = var12_13;
                        throw var12_13;
                    }
                    catch (Throwable var19_21) {
                        if (preparedStatement == null) throw var19_21;
                        if (var11_11 != null) {
                            try {
                                preparedStatement.close();
                                throw var19_21;
                            }
                            catch (Throwable var20_22) {
                                var11_11.addSuppressed(var20_22);
                                throw var19_21;
                            }
                        }
                        preparedStatement.close();
                        throw var19_21;
                    }
                    try {
                        preparedStatement.close();
                        return var14_15;
                    }
                    catch (Throwable var16_18) {
                        var11_11.addSuppressed(var16_18);
                        return var14_15;
                    }
                }
                preparedStatement.close();
                return var14_15;
            }
            catch (SQLException e) {
                this.logger.warn("exception on sets.inc()", e);
                throw new IOException(e);
            }
lbl-1000:
            // 1 sources

            {
                throw new IOException("cannot find entry for sets.inc()");
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void doAdd(String namespace, String set, String entry, long weight) throws IOException {
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s= ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        this.executeUpdate(sql, set, entry, weight, weight);
    }

    private void doAdd(String namespace, String set, Map<String, Long> entries) throws IOException {
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s= ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            for (Map.Entry<String, Long> entry : entries.entrySet()) {
                preparedStatement.clearParameters();
                preparedStatement.setString(1, set);
                preparedStatement.setString(2, entry.getKey());
                preparedStatement.setLong(3, entry.getValue());
                preparedStatement.setLong(4, entry.getValue());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.add()", e);
            throw new IOException(e);
        }
    }

    protected abstract String getCreateSetsTableSql(String var1);

    private String getOrderByString(boolean ascending) {
        String order = ascending ? " ASC " : " DESC ";
        return " ORDER BY " + this.getWeightColumnName() + " " + order + " ";
    }

    private String getLimitString(int start, int count) {
        if (start == 0 && count == -1) {
            return " ";
        }
        return " LIMIT " + start + "," + count;
    }

    protected String getSetsTableName() {
        return "CANTOR-SETS";
    }

    protected String getEntryColumnName() {
        return "ENTRY";
    }

    protected String getSetKeyColumnName() {
        return "SET-KEY";
    }

    protected String getWeightColumnName() {
        return "WEIGHT";
    }
}

