/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.async;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.async.AsyncEvents;
import com.salesforce.cantor.misc.async.AsyncObjects;
import com.salesforce.cantor.misc.async.AsyncSets;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCantor
implements Cantor {
    private static final Logger logger = LoggerFactory.getLogger(AsyncCantor.class);
    private final AsyncObjects objects;
    private final AsyncSets sets;
    private final AsyncEvents events;

    public AsyncCantor(Cantor delegate, ExecutorService executorService) {
        CommonPreconditions.checkArgument(delegate != null, "null delegate");
        CommonPreconditions.checkArgument(executorService != null, "null executor service");
        logger.info("new instance of async cantor created");
        this.objects = new AsyncObjects(delegate.objects(), executorService);
        this.sets = new AsyncSets(delegate.sets(), executorService);
        this.events = new AsyncEvents(delegate.events(), executorService);
    }

    @Override
    public Objects objects() {
        return this.objects;
    }

    @Override
    public Sets sets() {
        return this.sets;
    }

    @Override
    public Events events() {
        return this.events;
    }
}

