/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.loggable;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.loggable.LoggableEvents;
import com.salesforce.cantor.misc.loggable.LoggableObjects;
import com.salesforce.cantor.misc.loggable.LoggableSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggableCantor
implements Cantor {
    private static final Logger logger = LoggerFactory.getLogger(LoggableCantor.class);
    private final Objects objects;
    private final Sets sets;
    private final Events events;

    public LoggableCantor(Cantor delegate) {
        CommonPreconditions.checkArgument(delegate != null, "null delegate");
        logger.info("new instance of loggable cantor created");
        this.objects = new LoggableObjects(delegate.objects());
        this.sets = new LoggableSets(delegate.sets());
        this.events = new LoggableEvents(delegate.events());
    }

    @Override
    public Objects objects() {
        return this.objects;
    }

    @Override
    public Sets sets() {
        return this.sets;
    }

    @Override
    public Events events() {
        return this.events;
    }
}

