/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.loggable;

import com.salesforce.cantor.Events;
import com.salesforce.cantor.common.CommonUtils;
import com.salesforce.cantor.common.EventsPreconditions;
import com.salesforce.cantor.misc.loggable.AbstractBaseLoggableNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoggableEvents
extends AbstractBaseLoggableNamespaceable<Events>
implements Events {
    public LoggableEvents(Events delegate) {
        super(delegate);
    }

    @Override
    public void store(String namespace, Collection<Events.Event> batch) throws IOException {
        EventsPreconditions.checkStore(namespace, batch);
        this.logCall(() -> {
            ((Events)this.getDelegate()).store(namespace, batch);
            return null;
        }, "store", namespace, batch.size());
    }

    @Override
    public List<Events.Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        EventsPreconditions.checkGet(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.logCall(() -> ((Events)this.getDelegate()).get(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery, includePayloads, ascending, limit), "get", namespace, startTimestampMillis, endTimestampMillis, CommonUtils.nullToEmpty(metadataQuery).keySet(), CommonUtils.nullToEmpty(dimensionsQuery).keySet(), includePayloads, ascending, limit);
    }

    @Override
    public Set<String> metadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkMetadata(namespace, metadataKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.logCall(() -> ((Events)this.getDelegate()).metadata(namespace, metadataKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery), "metadata", namespace, metadataKey, startTimestampMillis, endTimestampMillis, CommonUtils.nullToEmpty(metadataQuery).keySet(), CommonUtils.nullToEmpty(dimensionsQuery).keySet());
    }

    @Override
    public List<Events.Event> dimension(String namespace, String dimensionKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkDimension(namespace, dimensionKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.logCall(() -> ((Events)this.getDelegate()).dimension(namespace, dimensionKey, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery), "dimension", namespace, dimensionKey, startTimestampMillis, endTimestampMillis, CommonUtils.nullToEmpty(metadataQuery).keySet(), CommonUtils.nullToEmpty(dimensionsQuery).keySet());
    }

    @Override
    public void expire(String namespace, long endTimestampMillis) throws IOException {
        EventsPreconditions.checkExpire(namespace, endTimestampMillis);
        this.logCall(() -> {
            ((Events)this.getDelegate()).expire(namespace, endTimestampMillis);
            return null;
        }, "expire", namespace, endTimestampMillis);
    }
}

