/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.sharded;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.sharded.ShardedEvents;
import com.salesforce.cantor.misc.sharded.ShardedObjects;
import com.salesforce.cantor.misc.sharded.ShardedSets;

public class ShardedCantor
implements Cantor {
    private final ShardedObjects objects;
    private final ShardedSets sets;
    private final ShardedEvents events;

    public ShardedCantor(Cantor ... delegates) {
        CommonPreconditions.checkArgument(delegates != null && delegates.length > 0, "null/empty delegates");
        Objects[] objects = new Objects[delegates.length];
        Sets[] sets = new Sets[delegates.length];
        Events[] events = new Events[delegates.length];
        for (int i = 0; i < delegates.length; ++i) {
            objects[i] = delegates[i].objects();
            sets[i] = delegates[i].sets();
            events[i] = delegates[i].events();
        }
        this.objects = new ShardedObjects(objects);
        this.sets = new ShardedSets(sets);
        this.events = new ShardedEvents(events);
    }

    @Override
    public Objects objects() {
        return this.objects;
    }

    @Override
    public Sets sets() {
        return this.sets;
    }

    @Override
    public Events events() {
        return this.events;
    }
}

