/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.mysql;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.jdbc.AbstractBaseSetsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.salesforce.cantor.mysql.MysqlDataSourceProvider;
import java.io.IOException;
import javax.sql.DataSource;

public class SetsOnMysql
extends AbstractBaseSetsOnJdbc
implements Sets {
    public SetsOnMysql(String hostname, int port, String username, String password) throws IOException {
        this(MysqlDataSourceProvider.getDatasource(new MysqlDataSourceProperties().setHostname(hostname).setPort(port).setUsername(username).setPassword(password)));
    }

    public SetsOnMysql(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    @Override
    protected String getCreateSetsTableSql(String namespace) {
        return "CREATE TABLE IF NOT EXISTS " + this.getTableFullName(namespace, this.getSetsTableName()) + " ( " + JdbcUtils.quote(this.getSetKeyColumnName()) + " VARCHAR(512) NOT NULL, " + JdbcUtils.quote(this.getEntryColumnName()) + " TEXT NOT NULL, " + JdbcUtils.quote(this.getWeightColumnName()) + " BIGINT,  PRIMARY KEY (" + JdbcUtils.quote(this.getSetKeyColumnName()) + ", " + JdbcUtils.quote(this.getEntryColumnName()) + "(512)),  INDEX (" + JdbcUtils.quote(this.getSetKeyColumnName()) + "),  INDEX (" + JdbcUtils.quote(this.getWeightColumnName()) + "))  ENGINE=InnoDB DEFAULT CHARSET=utf8 ";
    }
}

