/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.StringInputStream;
import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.s3.S3Utils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseS3Namespaceable
implements Namespaceable {
    protected static final String NAMESPACE_IDENTIFIER = ".namespace";
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseS3Namespaceable.class);
    protected final AmazonS3 s3Client;
    protected final String bucketName;

    public AbstractBaseS3Namespaceable(AmazonS3 s3Client, String bucketName, String type) throws IOException {
        CommonPreconditions.checkArgument(s3Client != null, "null s3 client");
        CommonPreconditions.checkString(bucketName, "null/empty bucket name");
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        try {
            this.s3Client.headBucket(new HeadBucketRequest(this.bucketName));
        }
        catch (SdkClientException e) {
            logger.warn("exception validating s3 client and bucket:", e);
            throw new IOException("exception validating s3 client and bucket", e);
        }
    }

    @Override
    public void create(String namespace) throws IOException {
        CommonPreconditions.checkCreate(namespace);
        try {
            this.doCreate(namespace);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception creating namespace: " + namespace, e);
            throw new IOException("exception creating namespace: " + namespace, e);
        }
    }

    @Override
    public void drop(String namespace) throws IOException {
        CommonPreconditions.checkDrop(namespace);
        try {
            this.doDrop(namespace);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception dropping namespace: " + namespace, e);
            throw new IOException("exception dropping namespace: " + namespace, e);
        }
    }

    protected abstract String getObjectKeyPrefix(String var1);

    private void doCreate(String namespace) throws IOException {
        logger.info("creating namespace: '{}'.'{}'", (Object)this.bucketName, (Object)namespace);
        String markerKey = this.getObjectKeyPrefix(namespace) + "/" + NAMESPACE_IDENTIFIER;
        if (S3Utils.doesObjectExist(this.s3Client, this.bucketName, markerKey)) {
            logger.info("namespace already exists: '{}'.'{}'", (Object)namespace, (Object)this.bucketName);
            return;
        }
        StringInputStream csvForNamespaces = new StringInputStream("namespace=" + namespace);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("text/plain");
        S3Utils.putObject(this.s3Client, this.bucketName, markerKey, csvForNamespaces, objectMetadata);
    }

    private void doDrop(String namespace) throws IOException {
        logger.info("dropping namespace: '{}'.'{}'", (Object)this.bucketName, (Object)namespace);
        String objectKeyPrefix = this.getObjectKeyPrefix(namespace);
        logger.debug("deleting all objects with prefix '{}.{}'", (Object)this.bucketName, (Object)objectKeyPrefix);
        S3Utils.deleteObjects(this.s3Client, this.bucketName, objectKeyPrefix);
    }

    protected static String trim(String namespace) {
        String cleanName = namespace.replaceAll("[^A-Za-z0-9_\\-/]", "").toLowerCase();
        return String.format("%s-%s", cleanName.substring(0, Math.min(64, cleanName.length())), Math.abs(namespace.hashCode()));
    }
}

