/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.common.ObjectsPreconditions;
import com.salesforce.cantor.s3.AbstractBaseS3Namespaceable;
import com.salesforce.cantor.s3.S3Utils;
import com.salesforce.cantor.s3.StreamingObjects;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectsOnS3
extends AbstractBaseS3Namespaceable
implements StreamingObjects {
    private static final Logger logger = LoggerFactory.getLogger(ObjectsOnS3.class);
    private static final String objectKeyPrefix = "cantor-objects";

    public ObjectsOnS3(AmazonS3 s3Client, String bucketName) throws IOException {
        super(s3Client, bucketName, "objects");
    }

    @Override
    public void store(String namespace, String key, byte[] bytes) throws IOException {
        ObjectsPreconditions.checkStore(namespace, key, bytes);
        try {
            this.doStore(namespace, key, new ByteArrayInputStream(bytes), bytes.length);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception storing object: " + namespace + "." + key, e);
            throw new IOException("exception storing object: " + namespace + "." + key, e);
        }
    }

    @Override
    public byte[] get(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkGet(namespace, key);
        try {
            return this.doGet(namespace, key);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception getting object: " + namespace + "." + key, e);
            throw new IOException("exception getting object: " + namespace + "." + key, e);
        }
    }

    @Override
    public boolean delete(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, key);
        try {
            return S3Utils.deleteObject(this.s3Client, this.bucketName, this.getObjectKey(namespace, key));
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception deleting object: " + namespace + "." + key, e);
            throw new IOException("exception deleting object: " + namespace + "." + key, e);
        }
    }

    @Override
    public Collection<String> keys(String namespace, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        try {
            return this.doKeys(namespace, "", start, count);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception getting keys of namespace: " + namespace, e);
            throw new IOException("exception getting keys of namespace: " + namespace, e);
        }
    }

    @Override
    public Collection<String> keys(String namespace, String prefix, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        try {
            return this.doKeys(namespace, prefix, start, count);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception getting keys of namespace: " + namespace, e);
            throw new IOException("exception getting keys of namespace: " + namespace, e);
        }
    }

    @Override
    public int size(String namespace) throws IOException {
        ObjectsPreconditions.checkSize(namespace);
        try {
            return this.doSize(namespace);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception getting size of namespace: " + namespace, e);
            throw new IOException("exception getting size of namespace: " + namespace, e);
        }
    }

    @Override
    public void store(String namespace, String key, InputStream stream, long length) throws IOException {
        CommonPreconditions.checkString(namespace);
        CommonPreconditions.checkString(key);
        CommonPreconditions.checkArgument(stream != null, "null stream");
        CommonPreconditions.checkArgument(length > 0L, "zero/negative length");
        try {
            this.doStore(namespace, key, stream, length);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception storing stream:", e);
        }
    }

    @Override
    public InputStream stream(String namespace, String key) throws IOException {
        CommonPreconditions.checkString(namespace);
        CommonPreconditions.checkString(key);
        try {
            return this.doStream(namespace, key);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception streaming:", e);
            return null;
        }
    }

    private void doStore(String namespace, String key, InputStream stream, long length) throws IOException {
        ObjectsPreconditions.checkNamespace(namespace);
        String objectName = this.getObjectKey(namespace, key);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(length);
        logger.info("storing stream with length={} at '{}.{}'", length, this.bucketName, objectName);
        S3Utils.putObject(this.s3Client, this.bucketName, objectName, stream, metadata);
    }

    private byte[] doGet(String namespace, String key) throws IOException {
        String objectName = this.getObjectKey(namespace, key);
        logger.debug("retrieving object at '{}.{}'", (Object)this.bucketName, (Object)objectName);
        if (!S3Utils.doesObjectExist(this.s3Client, this.bucketName, objectName)) {
            return null;
        }
        return S3Utils.getObjectBytes(this.s3Client, this.bucketName, objectName);
    }

    private InputStream doStream(String namespace, String key) throws IOException {
        String objectName = this.getObjectKey(namespace, key);
        if (!this.s3Client.doesObjectExist(this.bucketName, objectName)) {
            throw new IOException(String.format("couldn't find objectName '%s' for namespace '%s'", objectName, namespace));
        }
        return S3Utils.getObjectStream(this.s3Client, this.bucketName, objectName);
    }

    private int doSize(String namespace) {
        return S3Utils.getSize(this.s3Client, this.bucketName, this.getObjectKey(namespace, ""));
    }

    private Collection<String> doKeys(String namespace, String prefix, int start, int count) throws IOException {
        String namespaceObjectPrefix = this.getObjectKey(namespace, prefix);
        return S3Utils.getKeys(this.s3Client, this.bucketName, namespaceObjectPrefix, start, count).stream().filter(key -> !key.endsWith(".namespace")).map(objectFile -> objectFile.substring(namespaceObjectPrefix.length())).collect(Collectors.toList());
    }

    private String getObjectKey(String namespace, String key) {
        return String.format("%s/%s", this.getObjectKeyPrefix(namespace), key);
    }

    @Override
    protected String getObjectKeyPrefix(String namespace) {
        return String.format("%s/%s", objectKeyPrefix, ObjectsOnS3.trim(namespace));
    }
}

