/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CSVInput;
import com.amazonaws.services.s3.model.CSVOutput;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompressionType;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ExpressionType;
import com.amazonaws.services.s3.model.FileHeaderInfo;
import com.amazonaws.services.s3.model.InputSerialization;
import com.amazonaws.services.s3.model.JSONInput;
import com.amazonaws.services.s3.model.JSONOutput;
import com.amazonaws.services.s3.model.JSONType;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.OutputSerialization;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SelectObjectContentEvent;
import com.amazonaws.services.s3.model.SelectObjectContentEventVisitor;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.SelectRecordsInputStream;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Utils {
    private static final Logger logger = LoggerFactory.getLogger(S3Utils.class);
    private static final int streamingChunkSize = 0x400000;
    private static final Cache<String, byte[]> cache = CacheBuilder.newBuilder().maximumWeight(0x40000000L).weigher(new ObjectWeigher()).build();

    public static Collection<String> getKeys(AmazonS3 s3Client, String bucketName, String prefix) throws IOException {
        return S3Utils.getKeys(s3Client, bucketName, prefix, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<String> getKeys(AmazonS3 s3Client, String bucketName, String prefix, int start, int count) throws IOException {
        block6: {
            before = System.nanoTime();
            try {
                keys = new HashSet<String>();
                index = 0;
                listing = null;
                while (true) {
                    objectSummaries = (listing = listing == null ? s3Client.listObjects(bucketName, prefix) : s3Client.listNextBatchOfObjects(listing)).getObjectSummaries();
                    if (objectSummaries.size() - 1 + index < start) {
                        S3Utils.logger.debug("skipping {} objects to index={}", (Object)objectSummaries.size(), (Object)(index += objectSummaries.size()));
                        listing = s3Client.listNextBatchOfObjects(listing);
                        continue;
                    }
                    for (S3ObjectSummary summary : objectSummaries) {
                        if (start > index++) continue;
                        keys.add(summary.getKey());
                        if (keys.size() != count) continue;
                        S3Utils.logger.debug("retrieved {}/{} keys, returning early", (Object)keys.size(), (Object)count);
                        var13_12 = keys;
                        break block6;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Throwable var14_13) {
                S3Utils.logger.info("get keys - bucket: {} - prefix: {} - start: {} - count: {}; time spent: {}ms", new Object[]{bucketName, prefix, start, count, (System.nanoTime() - before) / 1000000L});
                throw var14_13;
            }
        }
        S3Utils.logger.info("get keys - bucket: {} - prefix: {} - start: {} - count: {}; time spent: {}ms", new Object[]{bucketName, prefix, start, count, (System.nanoTime() - before) / 1000000L});
        return var13_12;
lbl-1000:
        // 1 sources

        {
            S3Utils.logger.debug("got {} keys from {}", (Object)listing.getObjectSummaries().size(), (Object)listing);
            if (listing.isTruncated()) ** continue;
            var10_9 = keys;
        }
        S3Utils.logger.info("get keys - bucket: {} - prefix: {} - start: {} - count: {}; time spent: {}ms", new Object[]{bucketName, prefix, start, count, (System.nanoTime() - before) / 1000000L});
        return var10_9;
    }

    public static byte[] getObjectBytes(AmazonS3 s3Client, String bucketName, String key) throws IOException {
        return S3Utils.getObjectBytes(s3Client, bucketName, key, 0L, -1L);
    }

    /*
     * Exception decompiling
     */
    public static byte[] getObjectBytes(AmazonS3 s3Client, String bucketName, String key, long start, long end) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExist(AmazonS3 s3Client, String bucketName, String key) {
        boolean bl;
        long before = System.nanoTime();
        try {
            bl = s3Client.doesObjectExist(bucketName, key);
        }
        catch (Throwable throwable) {
            logger.info("does object exist - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
            throw throwable;
        }
        logger.info("does object exist - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getObjectStream(AmazonS3 s3Client, String bucketName, String key) {
        S3ObjectInputStream s3ObjectInputStream;
        long before = System.nanoTime();
        try {
            s3ObjectInputStream = s3Client.getObject(bucketName, key).getObjectContent();
        }
        catch (Throwable throwable) {
            logger.info("get object stream - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
            throw throwable;
        }
        logger.info("get object stream - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
        return s3ObjectInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject(AmazonS3 s3Client, String bucketName, String key, InputStream content, ObjectMetadata metadata) throws IOException {
        long before = System.nanoTime();
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, content, metadata);
            putObjectRequest.withCannedAcl(CannedAccessControlList.BucketOwnerFullControl);
            s3Client.putObject(putObjectRequest);
        }
        catch (Throwable throwable) {
            logger.info("put object - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
            throw throwable;
        }
        logger.info("put object - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteObject(AmazonS3 s3Client, String bucketName, String key) {
        long before;
        block3: {
            boolean bl;
            before = System.nanoTime();
            try {
                if (s3Client.doesObjectExist(bucketName, key)) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                logger.info("delete object - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
                throw throwable;
            }
            logger.info("delete object - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
            return bl;
        }
        s3Client.deleteObject(bucketName, key);
        boolean bl = true;
        logger.info("delete object - bucket: {} - key: {}; time spent: {}ms", bucketName, key, (System.nanoTime() - before) / 1000000L);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteObjects(AmazonS3 s3Client, String bucketName, Collection<String> keys) {
        long before;
        block3: {
            before = System.nanoTime();
            try {
                if (keys != null && !keys.isEmpty()) break block3;
            }
            catch (Throwable throwable) {
                logger.info("delete objects - bucket: {} - keys: {}; time spent: {}ms", bucketName, keys, (System.nanoTime() - before) / 1000000L);
                throw throwable;
            }
            logger.info("delete objects - bucket: {} - keys: {}; time spent: {}ms", bucketName, keys, (System.nanoTime() - before) / 1000000L);
            return;
        }
        DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
        request.setKeys(keys.stream().map(DeleteObjectsRequest.KeyVersion::new).collect(Collectors.toList()));
        s3Client.deleteObjects(request);
        logger.info("delete objects - bucket: {} - keys: {}; time spent: {}ms", bucketName, keys, (System.nanoTime() - before) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteObjects(AmazonS3 s3Client, String bucketName, String prefix) {
        long before = System.nanoTime();
        try {
            ObjectListing objectListing = s3Client.listObjects(bucketName, prefix);
            while (true) {
                for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
                    s3Client.deleteObject(bucketName, summary.getKey());
                }
                if (objectListing.isTruncated()) {
                    objectListing = s3Client.listNextBatchOfObjects(objectListing);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            logger.info("delete objects - bucket: {} - prefix: {}; time spent: {}ms", bucketName, prefix, (System.nanoTime() - before) / 1000000L);
            throw throwable;
        }
        logger.info("delete objects - bucket: {} - prefix: {}; time spent: {}ms", bucketName, prefix, (System.nanoTime() - before) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSize(AmazonS3 s3Client, String bucketName, String bucketPrefix) {
        int n;
        long before = System.nanoTime();
        try {
            int totalSize = 0;
            ObjectListing listing = null;
            do {
                listing = listing == null ? s3Client.listObjects(bucketName, bucketPrefix) : s3Client.listNextBatchOfObjects(listing);
                totalSize += listing.getObjectSummaries().size();
                logger.debug("got {} keys from {}", (Object)listing.getObjectSummaries().size(), (Object)listing);
            } while (listing.isTruncated());
            n = totalSize;
        }
        catch (Throwable throwable) {
            logger.info("get size - bucket: {} - prefix: {}; time spent: {}ms", bucketName, bucketPrefix, (System.nanoTime() - before) / 1000000L);
            throw throwable;
        }
        logger.info("get size - bucket: {} - prefix: {}; time spent: {}ms", bucketName, bucketPrefix, (System.nanoTime() - before) / 1000000L);
        return n;
    }

    public static String getCleanKeyForNamespace(String namespace) {
        String cleanName = namespace.replaceAll("[^A-Za-z0-9_\\-/]", "").toLowerCase();
        return String.format("cantor-%s-%s", cleanName.substring(0, Math.min(32, cleanName.length())), Math.abs(namespace.hashCode()));
    }

    private static class ObjectWeigher
    implements Weigher<String, byte[]> {
        private ObjectWeigher() {
        }

        @Override
        public int weigh(String keyIgnored, byte[] value) {
            return value.length;
        }
    }

    public static class S3Select {
        public static String queryObjectJson(AmazonS3 s3Client, String bucket, String key, String query) throws IOException {
            return S3Select.queryObject(s3Client, S3Select.generateJsonRequest(bucket, key, query));
        }

        public static String queryObjectCsv(AmazonS3 s3Client, String bucket, String key, String query) throws IOException {
            return S3Select.queryObject(s3Client, S3Select.generateCsvRequest(bucket, key, query));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String queryObject(AmazonS3 s3Client, final SelectObjectContentRequest request) throws IOException {
            String string;
            long before = System.nanoTime();
            try {
                StringBuilder results = new StringBuilder();
                try (SelectObjectContentResult result = s3Client.selectObjectContent(request);
                     SelectRecordsInputStream inputStream = result.getPayload().getRecordsInputStream(new SelectObjectContentEventVisitor(){

                    @Override
                    public void visit(SelectObjectContentEvent.StatsEvent event) {
                        logger.info("s3 select query stats: bucket='{}' key='{}' bytes-scanned='{}' bytes-processed='{}' bytes-returned='{}'", request.getBucketName(), request.getKey(), event.getDetails().getBytesProcessed(), event.getDetails().getBytesScanned(), event.getDetails().getBytesReturned());
                    }
                });
                     Scanner lineReader = new Scanner(inputStream);){
                    while (lineReader.hasNext()) {
                        results.append(lineReader.nextLine()).append("\n");
                    }
                }
                string = results.toString();
            }
            catch (Throwable throwable) {
                logger.info("query object - bucket: {} - key: {}; time spent: {}ms", request.getBucketName(), request.getKey(), (System.nanoTime() - before) / 1000000L);
                throw throwable;
            }
            logger.info("query object - bucket: {} - key: {}; time spent: {}ms", request.getBucketName(), request.getKey(), (System.nanoTime() - before) / 1000000L);
            return string;
        }

        public static SelectObjectContentRequest generateJsonRequest(String bucket, String key, String query) {
            SelectObjectContentRequest request = new SelectObjectContentRequest();
            request.setBucketName(bucket);
            request.setKey(key);
            request.setExpression(query);
            request.setExpressionType(ExpressionType.SQL);
            InputSerialization inputSerialization = new InputSerialization();
            inputSerialization.setJson(new JSONInput().withType(JSONType.LINES));
            inputSerialization.setCompressionType(CompressionType.NONE);
            request.setInputSerialization(inputSerialization);
            OutputSerialization outputSerialization = new OutputSerialization();
            outputSerialization.setJson(new JSONOutput());
            request.setOutputSerialization(outputSerialization);
            return request;
        }

        public static SelectObjectContentRequest generateCsvRequest(String bucket, String key, String query) {
            SelectObjectContentRequest request = new SelectObjectContentRequest();
            request.setBucketName(bucket);
            request.setKey(key);
            request.setExpression(query);
            request.setExpressionType(ExpressionType.SQL);
            InputSerialization inputSerialization = new InputSerialization();
            inputSerialization.setCsv(new CSVInput().withFileHeaderInfo(FileHeaderInfo.USE).withFieldDelimiter(","));
            inputSerialization.setCompressionType(CompressionType.NONE);
            request.setInputSerialization(inputSerialization);
            OutputSerialization outputSerialization = new OutputSerialization();
            outputSerialization.setCsv(new CSVOutput());
            request.setOutputSerialization(outputSerialization);
            return request;
        }
    }
}

