/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh;

import com.salesforce.reactivegrpc.jmh.proto.Messages;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import java.util.concurrent.CountDownLatch;
import org.openjdk.jmh.infra.Blackhole;

public class PerfObserver
implements ClientResponseObserver<Messages.SimpleRequest, Messages.SimpleResponse> {
    private final Blackhole blackhole;
    protected final CountDownLatch latch;
    protected ClientCallStreamObserver observer;

    public PerfObserver(Blackhole blackhole) {
        this.blackhole = blackhole;
        this.latch = new CountDownLatch(1);
    }

    public void beforeStart(ClientCallStreamObserver<Messages.SimpleRequest> observer) {
        this.observer = observer;
    }

    public void onNext(Messages.SimpleResponse response) {
        this.blackhole.consume(response);
    }

    public void onError(Throwable throwable) {
        throwable.printStackTrace();
        this.blackhole.consume(throwable);
        this.latch.countDown();
    }

    public void onCompleted() {
        this.latch.countDown();
    }
}

