/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.annotations.APParameterInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.ParameterInfo;

class APMethodInfo
extends APMetadataInfo
implements MethodInfo {
    private final ClassInfo ci;
    private final ExecutableElement el;

    public APMethodInfo(ProcessingEnvironment processEnv, ClassInfo ci, ExecutableElement el) {
        super(processEnv, el);
        if (ci == null) {
            throw new IllegalArgumentException("ci is null");
        }
        if (el == null) {
            throw new IllegalArgumentException("el is null");
        }
        this.ci = ci;
        this.el = el;
    }

    @Override
    public ClassInfo getDeclaringClass() {
        return this.ci;
    }

    @Override
    public String getName() {
        return this.el.getSimpleName().toString();
    }

    @Override
    public String getReturnType() {
        return this.el.getReturnType().toString();
    }

    @Override
    public Collection<ParameterInfo> getParameters() {
        ArrayList<ParameterInfo> pis = new ArrayList<ParameterInfo>();
        for (VariableElement variableElement : this.el.getParameters()) {
            pis.add(new APParameterInfo(this.processEnv, variableElement));
        }
        return pis;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.el.getAnnotation(annClass);
    }

    @Override
    public boolean isPublic() {
        return this.el.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isAbstract() {
        return this.el.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean isSynchronized() {
        return this.el.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }

    @Override
    public boolean isStrictFP() {
        return this.el.getModifiers().contains((Object)Modifier.STRICTFP);
    }

    @Override
    public boolean isStatic() {
        return this.el.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public String getQualifiedName() {
        return this.ci.getQualifiedName() + "." + this.el.toString();
    }

    @Override
    public int compareTo(MethodInfo o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }

    public String toString() {
        return this.getDeclaringClass() + " " + this.getName();
    }
}

