package com.salesforce.reactivegrpc.jmh.proto;

import static com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by ReactorGrpc generator",
comments = "Source: grpc/testing/services.proto")
public final class ReactorWorkerServiceGrpc {
    private ReactorWorkerServiceGrpc() {}

    public static ReactorWorkerServiceStub newReactorStub(io.grpc.Channel channel) {
        return new ReactorWorkerServiceStub(channel);
    }

    public static final class ReactorWorkerServiceStub extends io.grpc.stub.AbstractStub<ReactorWorkerServiceStub> {
        private WorkerServiceGrpc.WorkerServiceStub delegateStub;

        private ReactorWorkerServiceStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = WorkerServiceGrpc.newStub(channel);
        }

        private ReactorWorkerServiceStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = WorkerServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected ReactorWorkerServiceStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new ReactorWorkerServiceStub(channel, callOptions);
        }

        /**
         * <pre>
         *  One request followed by one response.
         *  The server returns the client payload as-is.
         * </pre>
         */
        public reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ServerStatus> runServer(reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ServerArgs> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.manyToMany(reactorRequest, delegateStub::runServer, getCallOptions());
        }

        /**
         * <pre>
         *  Repeated sequence of one request followed by one response.
         *  Should be called streaming ping-pong
         *  The server returns the client payload as-is on each response
         * </pre>
         */
        public reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ClientStatus> runClient(reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ClientArgs> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.manyToMany(reactorRequest, delegateStub::runClient, getCallOptions());
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from client to server
         *  The server returns the client payload as-is once the client does WritesDone
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.CoreResponse> coreCount(reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.CoreRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::coreCount, getCallOptions());
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from server to client
         *  The server repeatedly returns the client payload as-is
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.Void> quitWorker(reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.Void> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::quitWorker, getCallOptions());
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from client to server
         *  The server returns the client payload as-is once the client does WritesDone
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.CoreResponse> coreCount(com.salesforce.reactivegrpc.jmh.proto.Control.CoreRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::coreCount, getCallOptions());
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from server to client
         *  The server repeatedly returns the client payload as-is
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.Void> quitWorker(com.salesforce.reactivegrpc.jmh.proto.Control.Void reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::quitWorker, getCallOptions());
        }

    }

    public static abstract class WorkerServiceImplBase implements io.grpc.BindableService {


        /**
         * <pre>
         *  One request followed by one response.
         *  The server returns the client payload as-is.
         * </pre>
         */
        public reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ServerStatus> runServer(reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ServerArgs> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }


        /**
         * <pre>
         *  Repeated sequence of one request followed by one response.
         *  Should be called streaming ping-pong
         *  The server returns the client payload as-is on each response
         * </pre>
         */
        public reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ClientStatus> runClient(reactor.core.publisher.Flux<com.salesforce.reactivegrpc.jmh.proto.Control.ClientArgs> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from client to server
         *  The server returns the client payload as-is once the client does WritesDone
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.CoreResponse> coreCount(com.salesforce.reactivegrpc.jmh.proto.Control.CoreRequest request) {
            return coreCount(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from client to server
         *  The server returns the client payload as-is once the client does WritesDone
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.CoreResponse> coreCount(reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.CoreRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from server to client
         *  The server repeatedly returns the client payload as-is
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.Void> quitWorker(com.salesforce.reactivegrpc.jmh.proto.Control.Void request) {
            return quitWorker(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         *  Single-sided unbounded streaming from server to client
         *  The server repeatedly returns the client payload as-is
         * </pre>
         */
        public reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.Void> quitWorker(reactor.core.publisher.Mono<com.salesforce.reactivegrpc.jmh.proto.Control.Void> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc.getRunServerMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            com.salesforce.reactivegrpc.jmh.proto.Control.ServerArgs,
                                            com.salesforce.reactivegrpc.jmh.proto.Control.ServerStatus>(
                                            this, METHODID_RUN_SERVER)))
                    .addMethod(
                            com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc.getRunClientMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            com.salesforce.reactivegrpc.jmh.proto.Control.ClientArgs,
                                            com.salesforce.reactivegrpc.jmh.proto.Control.ClientStatus>(
                                            this, METHODID_RUN_CLIENT)))
                    .addMethod(
                            com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc.getCoreCountMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            com.salesforce.reactivegrpc.jmh.proto.Control.CoreRequest,
                                            com.salesforce.reactivegrpc.jmh.proto.Control.CoreResponse>(
                                            this, METHODID_CORE_COUNT)))
                    .addMethod(
                            com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc.getQuitWorkerMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            com.salesforce.reactivegrpc.jmh.proto.Control.Void,
                                            com.salesforce.reactivegrpc.jmh.proto.Control.Void>(
                                            this, METHODID_QUIT_WORKER)))
                    .build();
        }

        protected io.grpc.CallOptions getCallOptions(int methodId) {
            return null;
        }

        protected Throwable onErrorMap(Throwable throwable) {
            return com.salesforce.reactorgrpc.stub.ServerCalls.prepareError(throwable);
        }
    }

    public static final int METHODID_RUN_SERVER = 0;
    public static final int METHODID_RUN_CLIENT = 1;
    public static final int METHODID_CORE_COUNT = 2;
    public static final int METHODID_QUIT_WORKER = 3;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WorkerServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(WorkerServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_CORE_COUNT:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((com.salesforce.reactivegrpc.jmh.proto.Control.CoreRequest) request,
                            (io.grpc.stub.StreamObserver<com.salesforce.reactivegrpc.jmh.proto.Control.CoreResponse>) responseObserver,
                            serviceImpl::coreCount, serviceImpl::onErrorMap);
                    break;
                case METHODID_QUIT_WORKER:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((com.salesforce.reactivegrpc.jmh.proto.Control.Void) request,
                            (io.grpc.stub.StreamObserver<com.salesforce.reactivegrpc.jmh.proto.Control.Void>) responseObserver,
                            serviceImpl::quitWorker, serviceImpl::onErrorMap);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_RUN_SERVER:
                    return (io.grpc.stub.StreamObserver<Req>) com.salesforce.reactorgrpc.stub.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<com.salesforce.reactivegrpc.jmh.proto.Control.ServerStatus>) responseObserver,
                            serviceImpl::runServer, serviceImpl::onErrorMap, serviceImpl.getCallOptions(methodId));
                case METHODID_RUN_CLIENT:
                    return (io.grpc.stub.StreamObserver<Req>) com.salesforce.reactorgrpc.stub.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<com.salesforce.reactivegrpc.jmh.proto.Control.ClientStatus>) responseObserver,
                            serviceImpl::runClient, serviceImpl::onErrorMap, serviceImpl.getCallOptions(methodId));
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
