/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.utils;

import com.sdl.delivery.configuration.utils.ConditionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;

public class CollectionUtil {
    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c = CollectionUtil.cast(elementsToAdd);
            return addTo.addAll(c);
        }
        return CollectionUtil.addAll(addTo, ConditionUtil.checkNotNull(elementsToAdd).iterator());
    }

    private static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    private static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        ConditionUtil.checkNotNull(addTo);
        ConditionUtil.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        return CollectionUtil.getNext(iterable.iterator(), defaultValue);
    }

    private static <T> T getNext(Iterator<? extends T> iterator, T defaultValue) {
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <T> T getLast(Iterator<? extends T> iterator, T defaultValue) {
        T returnValue = defaultValue;
        while (iterator.hasNext()) {
            returnValue = iterator.next();
        }
        return returnValue;
    }

    public static boolean intersectIgnoreCase(Collection<String> collection1, Collection<String> collection2) {
        return collection1 != null && collection2 != null && !Collections.disjoint(collection1.stream().map(String::toUpperCase).collect(Collectors.toList()), collection2.stream().map(String::toUpperCase).collect(Collectors.toList()));
    }
}

