/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.utils;

import com.sdl.delivery.configuration.Configuration;
import com.sdl.delivery.configuration.ConfigurationException;
import com.sdl.delivery.configuration.Value;
import com.sdl.delivery.configuration.utils.ConditionUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationPropertyUtils.class);
    public static final String CONFIG_VALUE_PROPERTY_NAME = "Name";
    public static final String CONFIG_VALUE_PROPERTY_VALUE = "Value";

    public static String getNonEmptyStringProperty(Configuration propertiesConfig, String propertyName, String errorMessage) throws ConfigurationException {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(errorMessage), "ConfigurationException error message not provided");
        Optional<String> stringValue = ConfigurationPropertyUtils.getStringProperty(propertiesConfig, propertyName);
        if (!stringValue.isPresent() || stringValue.get().isEmpty()) {
            throw new ConfigurationException(errorMessage);
        }
        return stringValue.get();
    }

    public static Optional<String> getStringProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asString()) : Optional.empty();
    }

    public static Optional<Long> getLongProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asLong()) : Optional.empty();
    }

    public static Optional<BigInteger> getBigIntegerProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asBigInteger()) : Optional.empty();
    }

    public static Optional<Double> getDoubleProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asDouble()) : Optional.empty();
    }

    public static Optional<BigDecimal> getBigDecimalProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asBigDecimal()) : Optional.empty();
    }

    public static Optional<Boolean> getBooleanProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asBoolean()) : Optional.empty();
    }

    public static Optional<Calendar> getDateProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        Optional<Value> propertyValue = ConfigurationPropertyUtils.getValueProperty(propertiesConfig, propertyName);
        return propertyValue.isPresent() ? Optional.of(propertyValue.get().asDate()) : Optional.empty();
    }

    public static Optional<Value> getValueProperty(Configuration propertiesConfig, String propertyName) {
        ConditionUtil.checkNotNull(propertiesConfig, "Properties configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(propertyName), "Property name not provided or empty");
        try {
            return propertiesConfig.getConfigurations().stream().filter(propConfig -> ConfigurationPropertyUtils.getNameProperty(propConfig).isPresent() && propertyName.equals(ConfigurationPropertyUtils.getNameProperty(propConfig).get().asString())).map(ConfigurationPropertyUtils::getValueProperty).flatMap(ConfigurationPropertyUtils::optionalToStream).findFirst();
        }
        catch (ConfigurationException e) {
            LOG.error("property with name '{}' not found in the given Properties Configuration", (Object)propertyName);
            return Optional.empty();
        }
    }

    public static Optional<Value> getNameProperty(Configuration propertyConfig) {
        ConditionUtil.checkNotNull(propertyConfig, "Property configuration not provided");
        try {
            return Optional.ofNullable(propertyConfig.getValue(CONFIG_VALUE_PROPERTY_NAME));
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }

    public static Optional<Value> getValueProperty(Configuration propertyConfig) {
        ConditionUtil.checkNotNull(propertyConfig, "Property configuration not provided");
        try {
            return Optional.ofNullable(propertyConfig.getValue(CONFIG_VALUE_PROPERTY_VALUE));
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }

    public static <T> Stream<T> optionalToStream(Optional<T> optional) {
        ConditionUtil.checkNotNull(optional, "Property configuration not provided");
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static Optional<Map<String, String>> getConfigurationAsStringValues(Map<String, Value> configValuesMap) {
        if (configValuesMap != null) {
            return Optional.of(configValuesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, strValue -> ((Value)strValue.getValue()).asString())));
        }
        return Optional.empty();
    }
}

