/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.utils;

import com.sdl.delivery.configuration.Configuration;
import com.sdl.delivery.configuration.ConfigurationException;
import com.sdl.delivery.configuration.Value;
import com.sdl.delivery.configuration.utils.ConditionUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);

    public static String getNonEmptyString(Configuration configuration, String valueName, String errorMessage) throws ConfigurationException {
        ConditionUtil.checkNotNull(configuration, "Configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(valueName), "Value name not provided or empty");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(errorMessage), "ConfigurationException error message not provided");
        String stringValue = ConfigurationUtils.getValue(configuration, valueName, errorMessage).asString();
        if (ConditionUtil.isNullOrEmpty(stringValue)) {
            throw new ConfigurationException(errorMessage);
        }
        return stringValue;
    }

    public static Value getValue(Configuration configuration, String valueName, String errorMessage) throws ConfigurationException {
        ConditionUtil.checkNotNull(configuration, "Configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(valueName), "Value name not provided or empty");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(errorMessage), "ConfigurationException error message not provided");
        Optional<Value> configValue = ConfigurationUtils.getValue(configuration, valueName);
        if (!configValue.isPresent()) {
            throw new ConfigurationException(errorMessage);
        }
        return configValue.get();
    }

    public static Optional<Value> getValue(Configuration configuration, String valueName) {
        ConditionUtil.checkNotNull(configuration, "Configuration not provided");
        ConditionUtil.checkArgument(!ConditionUtil.isNullOrEmpty(valueName), "Value name not provided or empty");
        try {
            return Optional.ofNullable(configuration.getValue(valueName));
        }
        catch (ConfigurationException e) {
            LOG.warn("Could not get config value for " + valueName, (Throwable)((Object)e));
            return Optional.empty();
        }
    }
}

