/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.values;

import com.sdl.delivery.configuration.values.DefaultValue;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class DateValue
extends DefaultValue {
    private Calendar value;

    public DateValue(Calendar value) {
        this.value = value;
    }

    @Override
    public String asString() {
        return ZonedDateTime.ofInstant(this.value.toInstant(), this.value.getTimeZone().toZoneId()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @Override
    public Calendar asDate() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateValue dateValue = (DateValue)o;
        return this.value.equals(dateValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

