/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.values;

import com.sdl.delivery.configuration.values.DefaultValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericValue
extends DefaultValue {
    private static final Logger LOG = LoggerFactory.getLogger(NumericValue.class);
    private BigDecimal number;

    public NumericValue(BigDecimal bigDecimal) {
        this.number = bigDecimal;
    }

    @Override
    public String asString() {
        return this.number.toString();
    }

    @Override
    public double asDouble() {
        try {
            return this.number.doubleValue();
        }
        catch (NumberFormatException e) {
            LOG.warn(this.number + " cannot be converted into double", (Throwable)e);
            return super.asDouble();
        }
    }

    @Override
    public long asLong() {
        try {
            return this.number.longValue();
        }
        catch (NumberFormatException e) {
            LOG.warn(this.number + " cannot be converted into long", (Throwable)e);
            return super.asLong();
        }
    }

    @Override
    public BigInteger asBigInteger() {
        return this.number.toBigInteger();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericValue that = (NumericValue)o;
        return this.number.equals(that.number);
    }

    public int hashCode() {
        return this.number.hashCode();
    }
}

