/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.values;

import com.sdl.delivery.configuration.values.DefaultValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringValue
extends DefaultValue {
    private static final Logger LOG = LoggerFactory.getLogger(StringValue.class);
    private String value;

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public String asString() {
        return this.value == null ? super.asString() : this.value;
    }

    @Override
    public boolean asBoolean() {
        return "true".equals(this.value);
    }

    @Override
    public Calendar asDate() {
        try {
            if (this.value == null) {
                return super.asDate();
            }
            return GregorianCalendar.from(ZonedDateTime.parse(this.value));
        }
        catch (IllegalArgumentException e) {
            LOG.warn(this.value + " cannot be converted into a date", (Throwable)e);
            return super.asDate();
        }
    }

    @Override
    public double asDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException nfe) {
            LOG.warn(this.value + " cannot be converted into double", (Throwable)nfe);
            return super.asDouble();
        }
    }

    @Override
    public long asLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException nfe) {
            LOG.warn(this.value + " cannot be converted into long", (Throwable)nfe);
            return super.asLong();
        }
    }

    @Override
    public BigInteger asBigInteger() {
        try {
            return new BigInteger(this.value);
        }
        catch (NumberFormatException nfe) {
            LOG.warn(this.value + " cannot be converted into BigInteger", (Throwable)nfe);
            return super.asBigInteger();
        }
    }

    @Override
    public BigDecimal asBigDecimal() {
        try {
            return new BigDecimal(this.value);
        }
        catch (NumberFormatException nfe) {
            LOG.warn(this.value + " cannot be converted into BigDecimal", (Throwable)nfe);
            return super.asBigDecimal();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "StringValue{value='" + this.value + '\'' + "}";
    }
}

