/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.configuration.values;

import com.sdl.delivery.configuration.Value;
import com.sdl.delivery.configuration.values.ChildConfigurationValue;
import com.sdl.delivery.configuration.values.NullValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValueContainer
implements Serializable {
    private Map<String, Value> values = new HashMap<String, Value>();

    public ValueContainer() {
    }

    public ValueContainer(Map<String, Value> valueMap) {
        this.values.putAll(valueMap);
    }

    public void add(String key, Value value) {
        this.values.put(key, value);
    }

    public Set<String> getAllPropertyKeys() {
        return this.values.keySet();
    }

    public Set<String> getChildConfigKeys() {
        HashSet<String> childConfigKeys = new HashSet<String>();
        for (String propertyKey : this.values.keySet()) {
            int firstPeriod = propertyKey.indexOf(".");
            if (firstPeriod <= -1) continue;
            String childConfigValue = propertyKey.substring(0, firstPeriod);
            childConfigKeys.add(childConfigValue);
        }
        return childConfigKeys;
    }

    public Set<String> getChildPropertyKeys() {
        HashSet<String> childPropertyKeys = new HashSet<String>();
        for (String propertyKey : this.values.keySet()) {
            int firstPeriod = propertyKey.indexOf(".");
            if (firstPeriod != -1) continue;
            childPropertyKeys.add(propertyKey);
        }
        return childPropertyKeys;
    }

    public Set<String> getChildKeys() {
        Set<String> childKeys = this.getChildPropertyKeys();
        childKeys.addAll(this.getChildConfigKeys());
        return childKeys;
    }

    public Value get(String valueKey) {
        Value valueToReturn = this.values.get(valueKey);
        if (valueToReturn == null) {
            valueToReturn = this.findChildConfigurationValue(valueKey);
        }
        if (valueToReturn == null) {
            valueToReturn = new NullValue();
        }
        return valueToReturn;
    }

    private ChildConfigurationValue findChildConfigurationValue(String configKey) {
        HashMap<String, Value> childPropertyValues = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : this.values.entrySet()) {
            String propertyKey = entry.getKey();
            if (!propertyKey.startsWith(configKey + ".")) continue;
            String childPropertyKey = propertyKey.substring(configKey.length() + 1);
            childPropertyValues.put(childPropertyKey, entry.getValue());
        }
        if (childPropertyValues.size() > 0) {
            return new ChildConfigurationValue(childPropertyValues);
        }
        return null;
    }

    public boolean hasValues() {
        return this.values.size() > 0;
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }
}

