/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.api.definition;

import com.sdl.context.api.definition.ContextPropertyName;
import java.io.Serializable;

public class GenericContextPropertyName
implements ContextPropertyName,
Serializable {
    private String aspectName;
    private String localPropertyName;
    private String aspectQualifiedName;

    public GenericContextPropertyName(String aspectName, String localPropertyName) {
        this.aspectName = aspectName;
        this.localPropertyName = localPropertyName;
        this.initialise();
    }

    public static GenericContextPropertyName newPropertyName(String aspectName, String localPropertyName) {
        return new GenericContextPropertyName(aspectName, localPropertyName);
    }

    public static GenericContextPropertyName fromAspectQualifiedName(String aspectQualifiedName) {
        String[] parts = aspectQualifiedName.split("\\.");
        assert (parts.length == 2) : "Aspect qualified name does not have two parts : " + aspectQualifiedName;
        return new GenericContextPropertyName(parts[0], parts[1]);
    }

    private void initialise() {
        this.aspectQualifiedName = this.aspectName + "." + this.localPropertyName;
    }

    @Override
    public String getAspectQualifiedName() {
        return this.aspectQualifiedName;
    }

    @Override
    public String getAspectName() {
        return this.aspectName;
    }

    @Override
    public String getLocalPropertyName() {
        return this.localPropertyName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aspectName == null ? 0 : this.aspectName.hashCode());
        result = 31 * result + (this.localPropertyName == null ? 0 : this.localPropertyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericContextPropertyName other = (GenericContextPropertyName)obj;
        if (this.aspectName == null ? other.aspectName != null : !this.aspectName.equals(other.aspectName)) {
            return false;
        }
        return !(this.localPropertyName == null ? other.localPropertyName != null : !this.localPropertyName.equals(other.localPropertyName));
    }

    public String toString() {
        return this.aspectQualifiedName;
    }
}

