/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.api.resolution;

import com.sdl.context.api.resolution.Evidence;
import com.sdl.context.api.resolution.EvidenceItem;
import com.sdl.context.api.resolution.HierarchicalEvidence;
import com.sdl.context.api.resolution.ImmutableEvidence;
import com.sdl.context.api.resolution.ImmutableEvidenceItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EvidenceBuilder {
    private static final String DEFAULT_ORIGIN = "http";
    private static final String DEFAULT_KEY = "user-agent";
    private Map<String, EvidenceItem> map = new HashMap<String, EvidenceItem>();
    private Set<String> origins = new HashSet<String>();
    private Evidence parent;

    public static Evidence withUserAgent(String userAgent) {
        EvidenceBuilder evidenceBuilder = new EvidenceBuilder();
        evidenceBuilder.with(userAgent);
        return evidenceBuilder.build();
    }

    public static Evidence withEvidence(Map<String, Object> evidenceMap) {
        EvidenceBuilder evidenceBuilder = new EvidenceBuilder();
        evidenceBuilder.with(evidenceMap);
        return evidenceBuilder.build();
    }

    public EvidenceBuilder with(Object value) {
        return this.with(DEFAULT_KEY, value);
    }

    public EvidenceBuilder withPublicationId(Integer publicationId) {
        return this.with("publication-id", publicationId, "target-group");
    }

    public EvidenceBuilder with(String key, Object value) {
        return this.with(key, value, DEFAULT_ORIGIN);
    }

    public EvidenceBuilder with(String key, Object value, String origin) {
        return this.with(key, new ImmutableEvidenceItem(key, value, origin));
    }

    public EvidenceBuilder with(Map<String, Object> evidenceMap) {
        for (Map.Entry<String, Object> entry : evidenceMap.entrySet()) {
            this.with(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private EvidenceBuilder with(String key, EvidenceItem value) {
        this.map.put(key, value);
        this.origins.add(value.getOrigin());
        return this;
    }

    public EvidenceBuilder with(Evidence evidence) {
        this.parent = evidence;
        return this;
    }

    protected EvidenceItem get(String key) {
        EvidenceItem value = this.map.get(key);
        if (value == null && this.parent != null) {
            value = this.parent.get(key);
        }
        return value;
    }

    public Evidence build() {
        if (this.parent == null) {
            return new ImmutableEvidence(this.map, this.origins);
        }
        return new HierarchicalEvidence(this.parent, this.map, this.origins);
    }
}

